/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.schema.swapper;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlSchema;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;
import org.apache.shardingsphere.infra.yaml.schema.swapper.TableMetaDataYamlSwapper;

public final class SchemaYamlSwapper
implements YamlConfigurationSwapper<YamlSchema, ShardingSphereSchema> {
    @Override
    public YamlSchema swapToYamlConfiguration(ShardingSphereSchema schema) {
        Map tables = schema.getAllTableNames().stream().collect(Collectors.toMap(each -> each, each -> this.swapYamlTable(schema.get((String)each)), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        YamlSchema result = new YamlSchema();
        result.setTables(tables);
        return result;
    }

    @Override
    public ShardingSphereSchema swapToObject(YamlSchema yamlConfig) {
        return Optional.ofNullable(yamlConfig).map(this::swapSchema).orElseGet(ShardingSphereSchema::new);
    }

    private ShardingSphereSchema swapSchema(YamlSchema schema) {
        return new ShardingSphereSchema(null == schema.getTables() || schema.getTables().isEmpty() ? new LinkedHashMap<String, ShardingSphereTable>() : (Map)schema.getTables().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.swapTable((YamlTableMetaData)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)));
    }

    private ShardingSphereTable swapTable(YamlTableMetaData table) {
        return new TableMetaDataYamlSwapper().swapToObject(table);
    }

    private YamlTableMetaData swapYamlTable(ShardingSphereTable table) {
        return new TableMetaDataYamlSwapper().swapToYamlConfiguration(table);
    }
}

