/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.auth.Authentication;
import org.apache.shardingsphere.infra.config.DatabaseAccessConfiguration;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.context.schema.SchemaContexts;
import org.apache.shardingsphere.infra.context.schema.impl.StandardSchemaContexts;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorKernel;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.model.addressing.TableAddressingMetaData;
import org.apache.shardingsphere.infra.metadata.model.addressing.TableAddressingMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.model.datasource.CachedDatabaseMetaData;
import org.apache.shardingsphere.infra.metadata.model.datasource.DataSourcesMetaData;
import org.apache.shardingsphere.infra.metadata.model.logic.LogicSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.logic.LogicSchemaMetaDataLoader;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.ShardingSphereRulesBuilder;
import org.apache.shardingsphere.infra.schema.ShardingSphereSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaContextsBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaContextsBuilder.class);
    private final DatabaseType databaseType;
    private final Map<String, Map<String, DataSource>> dataSources;
    private final Map<String, Collection<RuleConfiguration>> ruleConfigs;
    private final Authentication authentication;
    private final ConfigurationProperties props;
    private final ExecutorKernel executorKernel;

    public SchemaContextsBuilder(DatabaseType databaseType, Map<String, Map<String, DataSource>> dataSources, Map<String, Collection<RuleConfiguration>> ruleConfigs, Properties props) {
        this(databaseType, dataSources, ruleConfigs, new Authentication(), props);
    }

    public SchemaContextsBuilder(DatabaseType databaseType, Map<String, Map<String, DataSource>> dataSources, Map<String, Collection<RuleConfiguration>> ruleConfigs, Authentication authentication, Properties props) {
        this.databaseType = databaseType;
        this.dataSources = dataSources;
        this.ruleConfigs = ruleConfigs;
        this.authentication = authentication;
        this.props = new ConfigurationProperties(null == props ? new Properties() : props);
        this.executorKernel = new ExecutorKernel(((Integer)this.props.getValue((Enum)ConfigurationPropertyKey.EXECUTOR_SIZE)).intValue());
    }

    public SchemaContexts build() throws SQLException {
        LinkedHashMap<String, ShardingSphereSchema> schemas = new LinkedHashMap<String, ShardingSphereSchema>(this.ruleConfigs.size(), 1.0f);
        for (String each : this.ruleConfigs.keySet()) {
            schemas.put(each, this.createSchema(each));
        }
        return new StandardSchemaContexts(schemas, this.executorKernel, this.authentication, this.props, this.databaseType);
    }

    private ShardingSphereSchema createSchema(String schemaName) throws SQLException {
        Map<String, DataSource> dataSources = this.dataSources.get(schemaName);
        Collection<RuleConfiguration> ruleConfigs = this.ruleConfigs.get(schemaName);
        Collection rules = ShardingSphereRulesBuilder.build(ruleConfigs, dataSources.keySet());
        return new ShardingSphereSchema(schemaName, ruleConfigs, rules, dataSources, this.createMetaData(schemaName, dataSources, rules));
    }

    private ShardingSphereMetaData createMetaData(String schemaName, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) throws SQLException {
        long start = System.currentTimeMillis();
        DataSourcesMetaData dataSourceMetas = new DataSourcesMetaData(this.databaseType, this.getDatabaseAccessConfigurationMap(dataSourceMap));
        LogicSchemaMetaData logicSchemaMetaData = new LogicSchemaMetaDataLoader(rules).load(this.databaseType, dataSourceMap, this.props);
        TableAddressingMetaData tableAddressingMetaData = TableAddressingMetaDataLoader.load((DatabaseType)this.databaseType, dataSourceMap, rules);
        CachedDatabaseMetaData cachedDatabaseMetaData = this.createCachedDatabaseMetaData(this.dataSources.get(schemaName)).orElse(null);
        ShardingSphereMetaData result = new ShardingSphereMetaData(dataSourceMetas, logicSchemaMetaData, tableAddressingMetaData, cachedDatabaseMetaData);
        log.info("Load meta data for schema {} finished, cost {} milliseconds.", (Object)schemaName, (Object)(System.currentTimeMillis() - start));
        return result;
    }

    private Map<String, DatabaseAccessConfiguration> getDatabaseAccessConfigurationMap(Map<String, DataSource> dataSourceMap) throws SQLException {
        LinkedHashMap<String, DatabaseAccessConfiguration> result = new LinkedHashMap<String, DatabaseAccessConfiguration>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            DataSource dataSource = entry.getValue();
            Connection connection = dataSource.getConnection();
            Throwable throwable = null;
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                result.put(entry.getKey(), new DatabaseAccessConfiguration(metaData.getURL(), metaData.getUserName()));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                connection.close();
            }
        }
        return result;
    }

    private Optional<CachedDatabaseMetaData> createCachedDatabaseMetaData(Map<String, DataSource> dataSources) throws SQLException {
        if (dataSources.isEmpty()) {
            return Optional.empty();
        }
        try (Connection connection = dataSources.values().iterator().next().getConnection();){
            Optional<CachedDatabaseMetaData> optional = Optional.of(new CachedDatabaseMetaData(connection.getMetaData()));
            return optional;
        }
    }
}

