/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.kernel;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorCallback;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorDataMap;
import org.apache.shardingsphere.infra.executor.kernel.InputGroup;
import org.apache.shardingsphere.infra.executor.kernel.impl.ShardingSphereExecutorService;

public final class ExecutorKernel
implements AutoCloseable {
    private final ShardingSphereExecutorService executorService;

    public ExecutorKernel(int executorSize) {
        this.executorService = new ShardingSphereExecutorService(executorSize);
    }

    public <I, O> List<O> execute(Collection<InputGroup<I>> inputGroups, ExecutorCallback<I, O> callback) throws SQLException {
        return this.execute(inputGroups, null, callback, false);
    }

    public <I, O> List<O> execute(Collection<InputGroup<I>> inputGroups, ExecutorCallback<I, O> firstCallback, ExecutorCallback<I, O> callback, boolean serial) throws SQLException {
        if (inputGroups.isEmpty()) {
            return Collections.emptyList();
        }
        return serial ? this.serialExecute(inputGroups, firstCallback, callback) : this.parallelExecute(inputGroups, firstCallback, callback);
    }

    private <I, O> List<O> serialExecute(Collection<InputGroup<I>> inputGroups, ExecutorCallback<I, O> firstCallback, ExecutorCallback<I, O> callback) throws SQLException {
        Iterator<InputGroup<I>> inputGroupsIterator = inputGroups.iterator();
        InputGroup<I> firstInputs = inputGroupsIterator.next();
        LinkedList<O> result = new LinkedList<O>(this.syncExecute(firstInputs, null == firstCallback ? callback : firstCallback));
        for (InputGroup each : Lists.newArrayList(inputGroupsIterator)) {
            result.addAll(this.syncExecute(each, callback));
        }
        return result;
    }

    private <I, O> List<O> parallelExecute(Collection<InputGroup<I>> inputGroups, ExecutorCallback<I, O> firstCallback, ExecutorCallback<I, O> callback) throws SQLException {
        Iterator<InputGroup<I>> inputGroupsIterator = inputGroups.iterator();
        InputGroup<I> firstInputs = inputGroupsIterator.next();
        Collection<ListenableFuture<Collection<O>>> restResultFutures = this.asyncExecute(Lists.newArrayList(inputGroupsIterator), callback);
        return this.getGroupResults(this.syncExecute(firstInputs, null == firstCallback ? callback : firstCallback), restResultFutures);
    }

    private <I, O> Collection<O> syncExecute(InputGroup<I> inputGroup, ExecutorCallback<I, O> callback) throws SQLException {
        return callback.execute(inputGroup.getInputs(), true, ExecutorDataMap.getValue());
    }

    private <I, O> Collection<ListenableFuture<Collection<O>>> asyncExecute(List<InputGroup<I>> inputGroups, ExecutorCallback<I, O> callback) {
        LinkedList<ListenableFuture<Collection<O>>> result = new LinkedList<ListenableFuture<Collection<O>>>();
        for (InputGroup<I> each : inputGroups) {
            result.add(this.asyncExecute(each, callback));
        }
        return result;
    }

    private <I, O> ListenableFuture<Collection<O>> asyncExecute(InputGroup<I> inputGroup, ExecutorCallback<I, O> callback) {
        Map<String, Object> dataMap = ExecutorDataMap.getValue();
        return this.executorService.getExecutorService().submit(() -> callback.execute(inputGroup.getInputs(), false, dataMap));
    }

    private <O> List<O> getGroupResults(Collection<O> firstResults, Collection<ListenableFuture<Collection<O>>> restFutures) throws SQLException {
        LinkedList<O> result = new LinkedList<O>(firstResults);
        for (ListenableFuture<Collection<O>> each : restFutures) {
            try {
                result.addAll((Collection)each.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                return this.throwException(ex);
            }
        }
        return result;
    }

    private <O> List<O> throwException(Exception exception) throws SQLException {
        if (exception.getCause() instanceof SQLException) {
            throw (SQLException)exception.getCause();
        }
        throw new ShardingSphereException(exception);
    }

    @Override
    public void close() {
        this.executorService.close();
    }

    @Generated
    public ShardingSphereExecutorService getExecutorService() {
        return this.executorService;
    }
}

