/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.context.PrimaryKeyMetaData;
import org.apache.shardingsphere.infra.executor.sql.context.SQLRuntimeContext;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.infra.rewrite.engine.result.GenericSQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.RouteSQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteResult;
import org.apache.shardingsphere.infra.rewrite.engine.result.SQLRewriteUnit;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;

public final class ExecutionContextBuilder {
    public static Collection<ExecutionUnit> build(ShardingSphereMetaData metaData, SQLRewriteResult sqlRewriteResult, SQLStatementContext<?> sqlStatementContext) {
        return sqlRewriteResult instanceof GenericSQLRewriteResult ? ExecutionContextBuilder.build(metaData, (GenericSQLRewriteResult)sqlRewriteResult, sqlStatementContext) : ExecutionContextBuilder.build(metaData, (RouteSQLRewriteResult)sqlRewriteResult);
    }

    private static Collection<ExecutionUnit> build(ShardingSphereMetaData metaData, GenericSQLRewriteResult sqlRewriteResult, SQLStatementContext<?> sqlStatementContext) {
        String dataSourceName = (String)metaData.getDataSourcesMetaData().getAllInstanceDataSourceNames().iterator().next();
        return Collections.singletonList(new ExecutionUnit(dataSourceName, new SQLUnit(sqlRewriteResult.getSqlRewriteUnit().getSql(), sqlRewriteResult.getSqlRewriteUnit().getParameters(), ExecutionContextBuilder.getSQLRuntimeContext(metaData, sqlStatementContext))));
    }

    private static Collection<ExecutionUnit> build(ShardingSphereMetaData metaData, RouteSQLRewriteResult sqlRewriteResult) {
        LinkedHashSet<ExecutionUnit> result = new LinkedHashSet<ExecutionUnit>();
        for (Map.Entry entry : sqlRewriteResult.getSqlRewriteUnits().entrySet()) {
            Collection tableMappers = ((RouteUnit)entry.getKey()).getTableMappers();
            result.add(new ExecutionUnit(((RouteUnit)entry.getKey()).getDataSourceMapper().getActualName(), new SQLUnit(((SQLRewriteUnit)entry.getValue()).getSql(), ((SQLRewriteUnit)entry.getValue()).getParameters(), ExecutionContextBuilder.getSQLRuntimeContext(metaData, tableMappers))));
        }
        return result;
    }

    private static SQLRuntimeContext getSQLRuntimeContext(ShardingSphereMetaData metaData, SQLStatementContext<?> sqlStatementContext) {
        return new SQLRuntimeContext(ExecutionContextBuilder.getLogicTableNames(sqlStatementContext), ExecutionContextBuilder.getActualTableNames(sqlStatementContext), ExecutionContextBuilder.getPrimaryKeyColumns(metaData, sqlStatementContext));
    }

    private static SQLRuntimeContext getSQLRuntimeContext(ShardingSphereMetaData metaData, Collection<RouteMapper> tableMappers) {
        return new SQLRuntimeContext(ExecutionContextBuilder.getLogicTableNames(tableMappers), ExecutionContextBuilder.getActualTableNames(tableMappers), ExecutionContextBuilder.getPrimaryKeyColumns(metaData, tableMappers));
    }

    private static List<String> getLogicTableNames(SQLStatementContext<?> sqlStatementContext) {
        return ExecutionContextBuilder.getGenericTableNames(sqlStatementContext);
    }

    private static List<String> getLogicTableNames(Collection<RouteMapper> tableMappers) {
        return null == tableMappers ? Collections.emptyList() : tableMappers.stream().map(RouteMapper::getLogicName).collect(Collectors.toList());
    }

    private static List<String> getActualTableNames(SQLStatementContext<?> sqlStatementContext) {
        return ExecutionContextBuilder.getGenericTableNames(sqlStatementContext);
    }

    private static List<String> getActualTableNames(Collection<RouteMapper> tableMappers) {
        if (null == tableMappers) {
            return Collections.emptyList();
        }
        return tableMappers.stream().map(RouteMapper::getActualName).collect(Collectors.toList());
    }

    private static List<String> getGenericTableNames(SQLStatementContext<?> sqlStatementContext) {
        TablesContext tablesContext = null;
        if (null != sqlStatementContext) {
            tablesContext = sqlStatementContext.getTablesContext();
        }
        return null == tablesContext ? Collections.emptyList() : new ArrayList(tablesContext.getTableNames());
    }

    private static List<PrimaryKeyMetaData> getPrimaryKeyColumns(ShardingSphereMetaData metaData, SQLStatementContext<?> sqlStatementContext) {
        return ExecutionContextBuilder.getPrimaryKeyColumns(metaData, ExecutionContextBuilder.getActualTableNames(sqlStatementContext));
    }

    private static List<PrimaryKeyMetaData> getPrimaryKeyColumns(ShardingSphereMetaData metaData, Collection<RouteMapper> tableMappers) {
        return ExecutionContextBuilder.getPrimaryKeyColumns(metaData, ExecutionContextBuilder.getLogicTableNames(tableMappers));
    }

    private static List<PrimaryKeyMetaData> getPrimaryKeyColumns(ShardingSphereMetaData metaData, List<String> actualTableNames) {
        LinkedList<PrimaryKeyMetaData> result = new LinkedList<PrimaryKeyMetaData>();
        for (String each : actualTableNames) {
            PhysicalTableMetaData tableMetaData = metaData.getSchemaMetaData().getSchemaMetaData().get(each);
            if (null == tableMetaData) continue;
            result.add(new PrimaryKeyMetaData(each, tableMetaData.getPrimaryKeyColumns()));
        }
        return result;
    }

    @Generated
    private ExecutionContextBuilder() {
    }
}

