/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.group;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.infra.executor.sql.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.resourced.group.ResourceManagedExecuteGroupEngine;
import org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.StatementExecuteUnit;
import org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.connection.JDBCExecutionConnection;
import org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.group.StatementOption;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public final class PreparedStatementExecuteGroupEngine
extends ResourceManagedExecuteGroupEngine<StatementExecuteUnit, JDBCExecutionConnection, Connection, StatementOption> {
    public PreparedStatementExecuteGroupEngine(int maxConnectionsSizePerQuery, JDBCExecutionConnection executionConnection, StatementOption option, Collection<ShardingSphereRule> rules) {
        super(maxConnectionsSizePerQuery, executionConnection, option, rules);
    }

    @Override
    protected StatementExecuteUnit createStorageResourceExecuteUnit(ExecutionUnit executionUnit, JDBCExecutionConnection executionConnection, Connection connection, ConnectionMode connectionMode, StatementOption option) throws SQLException {
        PreparedStatement preparedStatement = this.createPreparedStatement(executionUnit.getSqlUnit().getSql(), executionUnit.getSqlUnit().getParameters(), executionConnection, connection, connectionMode, option);
        return new StatementExecuteUnit(executionUnit, connectionMode, preparedStatement);
    }

    private PreparedStatement createPreparedStatement(String sql, List<Object> parameters, JDBCExecutionConnection executionConnection, Connection connection, ConnectionMode connectionMode, StatementOption statementOption) throws SQLException {
        return (PreparedStatement)executionConnection.createStorageResource(sql, parameters, connection, connectionMode, statementOption);
    }
}

