/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.resourced.jdbc.queryresult;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.executor.sql.QueryResult;

public final class MemoryQueryResult
implements QueryResult {
    private final ResultSetMetaData resultSetMetaData;
    private final Iterator<List<Object>> rows;
    private List<Object> currentRow;

    public MemoryQueryResult(ResultSet resultSet) throws SQLException {
        this.resultSetMetaData = resultSet.getMetaData();
        this.rows = this.getRows(resultSet);
    }

    private Iterator<List<Object>> getRows(ResultSet resultSet) throws SQLException {
        LinkedList result = new LinkedList();
        while (resultSet.next()) {
            ArrayList<Object> rowData = new ArrayList<Object>(resultSet.getMetaData().getColumnCount());
            for (int columnIndex = 1; columnIndex <= resultSet.getMetaData().getColumnCount(); ++columnIndex) {
                Object rowValue = this.getRowValue(resultSet, columnIndex);
                rowData.add(resultSet.wasNull() ? null : rowValue);
            }
            result.add(rowData);
        }
        return result.iterator();
    }

    private Object getRowValue(ResultSet resultSet, int columnIndex) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        switch (metaData.getColumnType(columnIndex)) {
            case 16: {
                return resultSet.getBoolean(columnIndex);
            }
            case -6: 
            case 5: {
                return resultSet.getInt(columnIndex);
            }
            case 4: {
                if (metaData.isSigned(columnIndex)) {
                    return resultSet.getInt(columnIndex);
                }
                return resultSet.getLong(columnIndex);
            }
            case -5: {
                if (metaData.isSigned(columnIndex)) {
                    return resultSet.getLong(columnIndex);
                }
                BigDecimal bigDecimal = resultSet.getBigDecimal(columnIndex);
                return bigDecimal == null ? null : bigDecimal.toBigInteger();
            }
            case 2: 
            case 3: {
                return resultSet.getBigDecimal(columnIndex);
            }
            case 6: 
            case 8: {
                return resultSet.getDouble(columnIndex);
            }
            case -1: 
            case 1: 
            case 12: {
                return resultSet.getString(columnIndex);
            }
            case 91: {
                return resultSet.getDate(columnIndex);
            }
            case 92: {
                return resultSet.getTime(columnIndex);
            }
            case 93: {
                return resultSet.getTimestamp(columnIndex);
            }
            case 2005: {
                return resultSet.getClob(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return resultSet.getBlob(columnIndex);
            }
            case 2003: {
                return resultSet.getArray(columnIndex);
            }
        }
        return resultSet.getObject(columnIndex);
    }

    @Override
    public ResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    @Override
    public boolean next() {
        if (this.rows.hasNext()) {
            this.currentRow = this.rows.next();
            return true;
        }
        this.currentRow = null;
        return false;
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) {
        return this.currentRow.get(columnIndex - 1);
    }

    @Override
    public Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        return this.currentRow.get(columnIndex - 1);
    }

    @Override
    public InputStream getInputStream(int columnIndex, String type) {
        return this.getInputStream(this.currentRow.get(columnIndex - 1));
    }

    private InputStream getInputStream(Object value) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(value);
        objectOutputStream.flush();
        objectOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public boolean wasNull() {
        return null == this.currentRow;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.resultSetMetaData.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) throws SQLException {
        return this.resultSetMetaData.getColumnName(columnIndex);
    }

    @Override
    public String getColumnLabel(int columnIndex) throws SQLException {
        return this.resultSetMetaData.getColumnLabel(columnIndex);
    }
}

