/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.check;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.check.SQLCheckException;
import org.apache.shardingsphere.infra.executor.check.SQLCheckResult;
import org.apache.shardingsphere.infra.executor.check.SQLChecker;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLCheckEngine {
    public static boolean check(String schemaName, Collection<ShardingSphereRule> rules, Grantee grantee) {
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServices(rules, SQLChecker.class).entrySet()) {
            boolean checkResult = ((SQLChecker)entry.getValue()).check(schemaName, grantee, (ShardingSphereRule)entry.getKey());
            if (checkResult) continue;
            return false;
        }
        return true;
    }

    public static void check(SQLStatement sqlStatement, List<Object> parameters, Collection<ShardingSphereRule> rules, String currentSchema, Map<String, ShardingSphereMetaData> metaDataMap, Grantee grantee) {
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServices(rules, SQLChecker.class).entrySet()) {
            SQLCheckResult checkResult = ((SQLChecker)entry.getValue()).check(sqlStatement, parameters, grantee, currentSchema, metaDataMap, (ShardingSphereRule)entry.getKey());
            if (checkResult.isPassed()) continue;
            throw new SQLCheckException(checkResult.getErrorMessage());
        }
    }

    public static boolean check(Grantee user, Collection<ShardingSphereRule> rules) {
        if (rules.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServices(rules, SQLChecker.class).entrySet()) {
            boolean checkResult = ((SQLChecker)entry.getValue()).check(user, (ShardingSphereRule)entry.getKey());
            if (checkResult) continue;
            return false;
        }
        return true;
    }

    public static boolean check(Grantee user, BiPredicate<Object, Object> validate, Object cipher, Collection<ShardingSphereRule> rules) {
        if (rules.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : OrderedSPIRegistry.getRegisteredServices(rules, SQLChecker.class).entrySet()) {
            boolean checkResult = ((SQLChecker)entry.getValue()).check(user, validate, cipher, (ShardingSphereRule)entry.getKey());
            if (checkResult) continue;
            return false;
        }
        return true;
    }

    @Generated
    private SQLCheckEngine() {
    }

    static {
        ShardingSphereServiceLoader.register(SQLChecker.class);
    }
}

