/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.RawSQLExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.raw.callback.RawExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessConstants;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class RawSQLExecutorCallback
implements ExecutorCallback<RawSQLExecutionUnit, ExecuteResult> {
    private final Collection<RawExecutorCallback> callbacks = ShardingSphereServiceLoader.getSingletonServiceInstances(RawExecutorCallback.class);

    public RawSQLExecutorCallback() {
        Preconditions.checkState((!this.callbacks.isEmpty() ? 1 : 0) != 0, (Object)"No raw executor callback implementation found.");
    }

    @Override
    public Collection<ExecuteResult> execute(Collection<RawSQLExecutionUnit> inputs, boolean isTrunkThread, Map<String, Object> dataMap) throws SQLException {
        Collection<ExecuteResult> result = this.callbacks.iterator().next().execute(inputs, isTrunkThread, dataMap);
        if (dataMap.containsKey(ExecuteProcessConstants.EXECUTE_ID.name())) {
            String executionID = dataMap.get(ExecuteProcessConstants.EXECUTE_ID.name()).toString();
            for (RawSQLExecutionUnit each : inputs) {
                ExecuteProcessEngine.finish(executionID, each);
            }
        }
        return result;
    }

    static {
        ShardingSphereServiceLoader.register(RawExecutorCallback.class);
    }
}

