/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Iterator;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;

public abstract class AbstractMemoryQueryResult
implements QueryResult {
    private final QueryResultMetaData metaData;
    private final Iterator<MemoryQueryResultDataRow> rows;
    private MemoryQueryResultDataRow currentRow;

    @Override
    public final boolean next() {
        if (this.rows.hasNext()) {
            this.currentRow = this.rows.next();
            return true;
        }
        this.currentRow = null;
        return false;
    }

    @Override
    public final Object getValue(int columnIndex, Class<?> type) {
        return this.currentRow.getValue().get(columnIndex - 1);
    }

    @Override
    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        return this.currentRow.getValue().get(columnIndex - 1);
    }

    @Override
    public final InputStream getInputStream(int columnIndex, String type) {
        return this.getInputStream(this.currentRow.getValue().get(columnIndex - 1));
    }

    private InputStream getInputStream(Object value) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(value);
        objectOutputStream.flush();
        objectOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    @Override
    public final boolean wasNull() {
        return null == this.currentRow;
    }

    @Override
    public final void close() {
    }

    @Generated
    protected AbstractMemoryQueryResult(QueryResultMetaData metaData, Iterator<MemoryQueryResultDataRow> rows) {
        this.metaData = metaData;
        this.rows = rows;
    }

    @Override
    @Generated
    public QueryResultMetaData getMetaData() {
        return this.metaData;
    }
}

