/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.execute;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.schema.Schema;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.SQLUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.stream.JDBCStreamQueryResult;
import org.apache.shardingsphere.infra.executor.sql.federate.execute.FederateExecutor;
import org.apache.shardingsphere.infra.executor.sql.federate.schema.FederateLogicSchema;
import org.apache.shardingsphere.infra.executor.sql.federate.schema.row.FederateRowExecutor;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.optimize.context.OptimizeContextFactory;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class FederateJDBCExecutor
implements FederateExecutor {
    public static final String CONNECTION_URL = "jdbc:calcite:";
    public static final String DRIVER_NAME = "org.apache.calcite.jdbc.Driver";
    private final String schema;
    private final OptimizeContextFactory factory;
    private final ConfigurationProperties props;
    private final JDBCExecutor jdbcExecutor;
    private Statement statement;

    public FederateJDBCExecutor(String schema, OptimizeContextFactory factory, ConfigurationProperties props, JDBCExecutor jdbcExecutor) {
        this.schema = schema;
        this.factory = factory;
        this.props = props;
        this.jdbcExecutor = jdbcExecutor;
    }

    @Override
    public List<QueryResult> executeQuery(ExecutionContext executionContext, JDBCExecutorCallback<? extends ExecuteResult> callback, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine) throws SQLException {
        JDBCStreamQueryResult result = new JDBCStreamQueryResult(this.execute(executionContext, callback, prepareEngine));
        return Collections.singletonList(result);
    }

    @Override
    public void close() throws SQLException {
        if (null != this.statement && !this.statement.isClosed()) {
            Connection connection = this.statement.getConnection();
            this.statement.close();
            connection.close();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    private ResultSet execute(ExecutionContext executionContext, JDBCExecutorCallback<? extends ExecuteResult> callback, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine) throws SQLException {
        SQLUnit sqlUnit = executionContext.getExecutionUnits().iterator().next().getSqlUnit();
        PreparedStatement statement = this.getConnection(executionContext, callback, prepareEngine).prepareStatement(SQLUtil.trimSemicolon((String)sqlUnit.getSql()));
        this.setParameters(statement, sqlUnit.getParameters());
        this.statement = statement;
        return statement.executeQuery();
    }

    private Connection getConnection(ExecutionContext executionContext, JDBCExecutorCallback<? extends ExecuteResult> callback, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine) throws SQLException {
        Connection result = DriverManager.getConnection(CONNECTION_URL, this.getProperties());
        CalciteConnection calciteConnection = result.unwrap(CalciteConnection.class);
        this.addSchema(calciteConnection, executionContext, callback, prepareEngine);
        return result;
    }

    private Properties getProperties() {
        Properties result = new Properties();
        result.setProperty(CalciteConnectionProperty.LEX.camelName(), this.factory.getProperties().getProperty(CalciteConnectionProperty.LEX.camelName()));
        result.setProperty(CalciteConnectionProperty.CONFORMANCE.camelName(), this.factory.getProperties().getProperty(CalciteConnectionProperty.CONFORMANCE.camelName()));
        return result;
    }

    private void addSchema(CalciteConnection calciteConnection, ExecutionContext executionContext, JDBCExecutorCallback<? extends ExecuteResult> callback, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine) throws SQLException {
        FederateRowExecutor executor = new FederateRowExecutor(this.props, this.jdbcExecutor, executionContext, callback, prepareEngine);
        FederateLogicSchema logicSchema = new FederateLogicSchema(this.factory.getSchemaMetadatas().getSchemaMetadataBySchemaName(this.schema), executor);
        calciteConnection.getRootSchema().add(this.schema, (Schema)logicSchema);
        calciteConnection.setSchema(this.schema);
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> parameters) throws SQLException {
        int count = 1;
        for (Object each : parameters) {
            preparedStatement.setObject(count, each);
            ++count;
        }
    }

    static {
        try {
            Class.forName(DRIVER_NAME);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}

