/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.schema.row;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;

public final class FederateRowEnumerator
implements Enumerator<Object[]> {
    private final Collection<QueryResult> queryResults = new LinkedList<QueryResult>();
    private final Iterator<QueryResult> iterator;
    private QueryResult currentResultSet;
    private Object[] currentRow;

    public FederateRowEnumerator(Collection<QueryResult> queryResults) {
        this.queryResults.addAll(queryResults);
        this.iterator = this.queryResults.iterator();
        this.currentResultSet = this.iterator.next();
    }

    public Object[] current() {
        return this.currentRow;
    }

    public boolean moveNext() {
        try {
            return this.moveNext0();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean moveNext0() throws SQLException {
        if (this.currentResultSet.next()) {
            this.setCurrentRow();
            return true;
        }
        if (!this.iterator.hasNext()) {
            this.currentRow = null;
            return false;
        }
        this.currentResultSet = this.iterator.next();
        if (this.currentResultSet.next()) {
            this.setCurrentRow();
            return true;
        }
        return false;
    }

    private void setCurrentRow() throws SQLException {
        int columnCount = this.currentResultSet.getMetaData().getColumnCount();
        this.currentRow = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this.currentRow[i] = this.currentResultSet.getValue(i + 1, Object.class);
        }
    }

    public void reset() {
    }

    public void close() {
        try {
            for (QueryResult each : this.queryResults) {
                each.close();
            }
            this.currentRow = null;
        }
        catch (SQLException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
    }
}

