/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.federate.schema.row;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.rex.RexNode;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.kernel.model.ExecutionGroupContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.federate.schema.table.generator.FederateExecutionContextGenerator;
import org.apache.shardingsphere.infra.executor.sql.federate.schema.table.generator.FederateExecutionSQLGenerator;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.executor.sql.process.ExecuteProcessEngine;

public final class FederateRowExecutor {
    private final ConfigurationProperties props;
    private final JDBCExecutor jdbcExecutor;
    private final ExecutionContext routeExecutionContext;
    private final JDBCExecutorCallback<? extends ExecuteResult> callback;
    private final DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine;

    public Collection<QueryResult> execute(String logicTable, DataContext root, List<RexNode> filters, int[] projects) {
        FederateExecutionContextGenerator generator = new FederateExecutionContextGenerator(logicTable, this.routeExecutionContext, new FederateExecutionSQLGenerator(root, filters, projects));
        return this.execute(generator.generate());
    }

    private Collection<QueryResult> execute(ExecutionContext context) {
        try {
            ExecutionGroupContext<JDBCExecutionUnit> executionGroupContext = this.prepareEngine.prepare(context.getRouteContext(), context.getExecutionUnits());
            ExecuteProcessEngine.initialize(context.getSqlStatementContext(), executionGroupContext, this.props);
            Collection result = this.jdbcExecutor.execute(executionGroupContext, this.callback).stream().map(each -> (QueryResult)each).collect(Collectors.toList());
            ExecuteProcessEngine.finish(executionGroupContext.getExecutionID());
            Collection collection = result;
            return collection;
        }
        catch (SQLException ex) {
            throw new ShardingSphereException((Exception)ex);
        }
        finally {
            ExecuteProcessEngine.clean();
        }
    }

    @Generated
    public FederateRowExecutor(ConfigurationProperties props, JDBCExecutor jdbcExecutor, ExecutionContext routeExecutionContext, JDBCExecutorCallback<? extends ExecuteResult> callback, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine) {
        this.props = props;
        this.jdbcExecutor = jdbcExecutor;
        this.routeExecutionContext = routeExecutionContext;
        this.callback = callback;
        this.prepareEngine = prepareEngine;
    }
}

