/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.check;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.check.SQLCheckException;
import org.apache.shardingsphere.infra.executor.check.SQLCheckResult;
import org.apache.shardingsphere.infra.executor.check.SQLChecker;
import org.apache.shardingsphere.infra.executor.check.SQLCheckerFactory;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLCheckEngine {
    public static boolean check(String databaseName, Collection<ShardingSphereRule> rules, Grantee grantee) {
        for (Map.Entry<ShardingSphereRule, SQLChecker> entry : SQLCheckerFactory.getInstance(rules).entrySet()) {
            boolean checkResult = entry.getValue().check(databaseName, grantee, entry.getKey());
            if (checkResult) continue;
            return false;
        }
        return true;
    }

    public static void check(SQLStatement sqlStatement, List<Object> parameters, Collection<ShardingSphereRule> rules, String currentDatabase, Map<String, ShardingSphereDatabase> databases, Grantee grantee) {
        for (Map.Entry<ShardingSphereRule, SQLChecker> entry : SQLCheckerFactory.getInstance(rules).entrySet()) {
            SQLCheckResult checkResult = entry.getValue().check(sqlStatement, parameters, grantee, currentDatabase, databases, entry.getKey());
            if (checkResult.isPassed()) continue;
            throw new SQLCheckException(checkResult.getErrorMessage());
        }
    }

    public static boolean check(Grantee user, Collection<ShardingSphereRule> rules) {
        if (rules.isEmpty()) {
            return false;
        }
        for (Map.Entry<ShardingSphereRule, SQLChecker> entry : SQLCheckerFactory.getInstance(rules).entrySet()) {
            boolean checkResult = entry.getValue().check(user, entry.getKey());
            if (checkResult) continue;
            return false;
        }
        return true;
    }

    public static boolean check(Grantee user, BiPredicate<Object, Object> validate, Object cipher, Collection<ShardingSphereRule> rules) {
        if (rules.isEmpty()) {
            return false;
        }
        for (Map.Entry<ShardingSphereRule, SQLChecker> entry : SQLCheckerFactory.getInstance(rules).entrySet()) {
            boolean checkResult = entry.getValue().check(user, validate, cipher, entry.getKey());
            if (checkResult) continue;
            return false;
        }
        return true;
    }

    @Generated
    private SQLCheckEngine() {
    }
}

