/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.optimizer.metadata;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereColumn;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;

public final class FederationTableMetaData {
    private static final RelDataTypeFactory REL_DATA_TYPE_FACTORY = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
    private final String name;
    private final RelProtoDataType relProtoDataType;
    private final List<String> columnNames;

    public FederationTableMetaData(String name, ShardingSphereTable table) {
        this.name = name;
        this.relProtoDataType = this.createRelProtoDataType(table);
        this.columnNames = table.getColumns().values().stream().map(ShardingSphereColumn::getName).collect(Collectors.toList());
    }

    private RelProtoDataType createRelProtoDataType(ShardingSphereTable table) {
        RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = REL_DATA_TYPE_FACTORY.builder();
        for (ShardingSphereColumn each : table.getColumns().values()) {
            fieldInfoBuilder.add(each.getName(), this.getRelDataType(each));
        }
        return RelDataTypeImpl.proto((RelDataType)fieldInfoBuilder.build());
    }

    private RelDataType getRelDataType(ShardingSphereColumn column) {
        Class sqlTypeClass = SqlType.valueOf((int)column.getDataType()).clazz;
        RelDataType javaType = REL_DATA_TYPE_FACTORY.createJavaType(sqlTypeClass);
        return REL_DATA_TYPE_FACTORY.createTypeWithNullability(javaType, true);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public RelProtoDataType getRelProtoDataType() {
        return this.relProtoDataType;
    }

    @Generated
    public List<String> getColumnNames() {
        return this.columnNames;
    }
}

