/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser;

import org.apache.shardingsphere.distsql.parser.api.DistSQLStatementParserEngine;
import org.apache.shardingsphere.infra.parser.hook.ParsingHookRegistry;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngine;
import org.apache.shardingsphere.infra.parser.sql.SQLStatementParserEngineFactory;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ShardingSphereSQLParserEngine {
    private final SQLStatementParserEngine sqlStatementParserEngine;
    private final DistSQLStatementParserEngine distSQLStatementParserEngine;
    private final ParsingHookRegistry parsingHookRegistry;

    public ShardingSphereSQLParserEngine(String databaseTypeName) {
        this.sqlStatementParserEngine = SQLStatementParserEngineFactory.getSQLStatementParserEngine(databaseTypeName);
        this.distSQLStatementParserEngine = new DistSQLStatementParserEngine();
        this.parsingHookRegistry = ParsingHookRegistry.getInstance();
    }

    public SQLStatement parse(String sql, boolean useCache) {
        this.parsingHookRegistry.start(sql);
        try {
            SQLStatement result = this.parse0(sql, useCache);
            this.parsingHookRegistry.finishSuccess(result);
            return result;
        }
        catch (Exception ex) {
            this.parsingHookRegistry.finishFailure(ex);
            throw ex;
        }
    }

    private SQLStatement parse0(String sql, boolean useCache) {
        try {
            return this.sqlStatementParserEngine.parse(sql, useCache);
        }
        catch (SQLParsingException originalEx) {
            try {
                return this.distSQLStatementParserEngine.parse(sql);
            }
            catch (SQLParsingException ignored) {
                throw originalEx;
            }
        }
    }
}

