/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.sql;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import org.apache.shardingsphere.sql.parser.api.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.api.SQLVisitorEngine;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class SQLStatementParserEngine {
    private final SQLParserEngine parserEngine;
    private final SQLVisitorEngine visitorEngine;
    private final Cache<String, SQLStatement> cache = CacheBuilder.newBuilder().softValues().initialCapacity(2000).maximumSize(65535L).build();

    public SQLStatementParserEngine(String databaseTypeName) {
        this.parserEngine = new SQLParserEngine(databaseTypeName);
        this.visitorEngine = new SQLVisitorEngine(databaseTypeName, "STATEMENT");
    }

    public SQLStatement parse(String sql, boolean useCache) {
        if (!useCache) {
            return this.parse(sql);
        }
        Optional<Object> statement = Optional.ofNullable(this.cache.getIfPresent((Object)sql));
        if (statement.isPresent()) {
            return (SQLStatement)statement.get();
        }
        SQLStatement result = this.parse(sql);
        this.cache.put((Object)sql, (Object)result);
        return result;
    }

    private SQLStatement parse(String sql) {
        return (SQLStatement)this.visitorEngine.visit(this.parserEngine.parse(sql, false));
    }
}

