/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.route.engine;

import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.engine.SQLRouteExecutor;
import org.apache.shardingsphere.infra.route.engine.impl.AllSQLRouteExecutor;
import org.apache.shardingsphere.infra.route.engine.impl.PartialSQLRouteExecutor;
import org.apache.shardingsphere.infra.route.hook.SPIRoutingHook;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowTablesStatement;

public final class SQLRouteEngine {
    private final Collection<ShardingSphereRule> rules;
    private final ConfigurationProperties props;
    private final SPIRoutingHook routingHook = new SPIRoutingHook();

    public RouteContext route(LogicSQL logicSQL, ShardingSphereSchema schema) {
        this.routingHook.start(logicSQL.getSql());
        try {
            SQLRouteExecutor executor = this.isNeedAllSchemas(logicSQL.getSqlStatementContext().getSqlStatement()) ? new AllSQLRouteExecutor() : new PartialSQLRouteExecutor(this.rules, this.props);
            RouteContext result = executor.route(logicSQL, schema);
            this.routingHook.finishSuccess(result, schema.getMetaData().getSchemaMetaData().getConfiguredSchemaMetaData());
            return result;
        }
        catch (Exception ex) {
            this.routingHook.finishFailure(ex);
            throw ex;
        }
    }

    private boolean isNeedAllSchemas(SQLStatement sqlStatement) {
        return sqlStatement instanceof MySQLShowTablesStatement;
    }

    @Generated
    public SQLRouteEngine(Collection<ShardingSphereRule> rules, ConfigurationProperties props) {
        this.rules = rules;
        this.props = props;
    }
}

