/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.underlying.pluggble.prepare;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.spi.order.OrderedRegistry;
import org.apache.shardingsphere.sql.parser.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.underlying.common.config.properties.ConfigurationPropertyKey;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;
import org.apache.shardingsphere.underlying.common.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.underlying.common.rule.BaseRule;
import org.apache.shardingsphere.underlying.executor.context.ExecutionContext;
import org.apache.shardingsphere.underlying.executor.context.ExecutionUnit;
import org.apache.shardingsphere.underlying.executor.context.SQLUnit;
import org.apache.shardingsphere.underlying.executor.log.SQLLogger;
import org.apache.shardingsphere.underlying.rewrite.SQLRewriteEntry;
import org.apache.shardingsphere.underlying.rewrite.context.SQLRewriteContext;
import org.apache.shardingsphere.underlying.rewrite.context.SQLRewriteContextDecorator;
import org.apache.shardingsphere.underlying.rewrite.engine.SQLRewriteEngine;
import org.apache.shardingsphere.underlying.rewrite.engine.SQLRewriteResult;
import org.apache.shardingsphere.underlying.rewrite.engine.SQLRouteRewriteEngine;
import org.apache.shardingsphere.underlying.route.DataNodeRouter;
import org.apache.shardingsphere.underlying.route.context.RouteContext;
import org.apache.shardingsphere.underlying.route.context.RouteUnit;
import org.apache.shardingsphere.underlying.route.decorator.RouteDecorator;

public abstract class BasePrepareEngine {
    private final Collection<BaseRule> rules;
    private final ConfigurationProperties properties;
    private final ShardingSphereMetaData metaData;
    private final DataNodeRouter router;
    private final SQLRewriteEntry rewriter;

    public BasePrepareEngine(Collection<BaseRule> rules, ConfigurationProperties properties, ShardingSphereMetaData metaData, SQLParserEngine parser) {
        this.rules = rules;
        this.properties = properties;
        this.metaData = metaData;
        this.router = new DataNodeRouter(metaData, properties, parser);
        this.rewriter = new SQLRewriteEntry(metaData.getSchema(), properties);
    }

    public ExecutionContext prepare(String sql, List<Object> parameters) {
        List<Object> clonedParameters = this.cloneParameters(parameters);
        RouteContext routeContext = this.executeRoute(sql, clonedParameters);
        ExecutionContext result = new ExecutionContext(routeContext.getSqlStatementContext());
        result.getExecutionUnits().addAll(this.executeRewrite(sql, clonedParameters, routeContext));
        if (((Boolean)this.properties.getValue((Enum)ConfigurationPropertyKey.SQL_SHOW)).booleanValue()) {
            SQLLogger.logSQL((String)sql, (boolean)((Boolean)this.properties.getValue((Enum)ConfigurationPropertyKey.SQL_SIMPLE)), (SQLStatementContext)result.getSqlStatementContext(), (Collection)result.getExecutionUnits());
        }
        return result;
    }

    protected abstract List<Object> cloneParameters(List<Object> var1);

    private RouteContext executeRoute(String sql, List<Object> clonedParameters) {
        this.registerRouteDecorator();
        return this.route(this.router, sql, clonedParameters);
    }

    private void registerRouteDecorator() {
        for (Class each : OrderedRegistry.getRegisteredClasses(RouteDecorator.class)) {
            RouteDecorator routeDecorator = this.createRouteDecorator(each);
            Class ruleClass = (Class)routeDecorator.getType();
            this.rules.stream().filter(rule -> rule.getClass() == ruleClass || rule.getClass().getSuperclass() == ruleClass).collect(Collectors.toList()).forEach(rule -> this.router.registerDecorator(rule, routeDecorator));
        }
    }

    private RouteDecorator createRouteDecorator(Class<? extends RouteDecorator> decorator) {
        try {
            return decorator.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ShardingSphereException(String.format("Can not find public default constructor for route decorator `%s`", decorator), (Exception)ex);
        }
    }

    protected abstract RouteContext route(DataNodeRouter var1, String var2, List<Object> var3);

    private Collection<ExecutionUnit> executeRewrite(String sql, List<Object> parameters, RouteContext routeContext) {
        this.registerRewriteDecorator();
        SQLRewriteContext sqlRewriteContext = this.rewriter.createSQLRewriteContext(sql, parameters, routeContext.getSqlStatementContext(), routeContext);
        return routeContext.getRouteResult().getRouteUnits().isEmpty() ? this.rewrite(sqlRewriteContext) : this.rewrite(routeContext, sqlRewriteContext);
    }

    private void registerRewriteDecorator() {
        for (Class each : OrderedRegistry.getRegisteredClasses(SQLRewriteContextDecorator.class)) {
            SQLRewriteContextDecorator rewriteContextDecorator = this.createRewriteDecorator(each);
            Class ruleClass = (Class)rewriteContextDecorator.getType();
            this.rules.stream().filter(rule -> rule.getClass() == ruleClass || rule.getClass().getSuperclass() == ruleClass).collect(Collectors.toList()).forEach(rule -> this.rewriter.registerDecorator(rule, rewriteContextDecorator));
        }
    }

    private SQLRewriteContextDecorator createRewriteDecorator(Class<? extends SQLRewriteContextDecorator> decorator) {
        try {
            return decorator.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ShardingSphereException(String.format("Can not find public default constructor for rewrite decorator `%s`", decorator), (Exception)ex);
        }
    }

    private Collection<ExecutionUnit> rewrite(SQLRewriteContext sqlRewriteContext) {
        SQLRewriteResult sqlRewriteResult = new SQLRewriteEngine().rewrite(sqlRewriteContext);
        String dataSourceName = (String)this.metaData.getDataSources().getAllInstanceDataSourceNames().iterator().next();
        return Collections.singletonList(new ExecutionUnit(dataSourceName, new SQLUnit(sqlRewriteResult.getSql(), sqlRewriteResult.getParameters())));
    }

    private Collection<ExecutionUnit> rewrite(RouteContext routeContext, SQLRewriteContext sqlRewriteContext) {
        LinkedHashSet<ExecutionUnit> result = new LinkedHashSet<ExecutionUnit>();
        for (Map.Entry entry : new SQLRouteRewriteEngine().rewrite(sqlRewriteContext, routeContext.getRouteResult()).entrySet()) {
            result.add(new ExecutionUnit(((RouteUnit)entry.getKey()).getDataSourceMapper().getActualName(), new SQLUnit(((SQLRewriteResult)entry.getValue()).getSql(), ((SQLRewriteResult)entry.getValue()).getParameters())));
        }
        return result;
    }

    @Generated
    public BasePrepareEngine(Collection<BaseRule> rules, ConfigurationProperties properties, ShardingSphereMetaData metaData, DataNodeRouter router, SQLRewriteEntry rewriter) {
        this.rules = rules;
        this.properties = properties;
        this.metaData = metaData;
        this.router = router;
        this.rewriter = rewriter;
    }
}

