/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.metadata;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.metadata.model.addressing.TableAddressingMetaData;
import org.apache.shardingsphere.infra.metadata.model.addressing.TableAddressingMetaDataDecorator;
import org.apache.shardingsphere.replicaquery.rule.ReplicaQueryDataSourceRule;
import org.apache.shardingsphere.replicaquery.rule.ReplicaQueryRule;

public final class ReplicaQueryTableAddressingMetaDataDecorator
implements TableAddressingMetaDataDecorator<ReplicaQueryRule> {
    public void decorate(ReplicaQueryRule rule, TableAddressingMetaData metaData) {
        for (String each : rule.getAllLogicDataSourceNames()) {
            rule.findDataSourceRule(each).ifPresent(dataSourceRule -> this.decorate((ReplicaQueryDataSourceRule)dataSourceRule, metaData));
        }
    }

    private void decorate(ReplicaQueryDataSourceRule dataSourceRule, TableAddressingMetaData metaData) {
        for (Map.Entry entry : metaData.getTableDataSourceNamesMapper().entrySet()) {
            ((Collection)entry.getValue()).remove(dataSourceRule.getPrimaryDataSourceName());
            ((Collection)entry.getValue()).removeAll(dataSourceRule.getReplicaDataSourceNames());
            ((Collection)entry.getValue()).add(dataSourceRule.getName());
        }
    }

    public int getOrder() {
        return 10;
    }

    public Class<ReplicaQueryRule> getTypeClass() {
        return ReplicaQueryRule.class;
    }
}

