/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.replicaquery.api.config.rule.ReplicaQueryDataSourceRuleConfiguration;
import org.apache.shardingsphere.replicaquery.spi.ReplicaLoadBalanceAlgorithm;

public final class ReplicaQueryDataSourceRule {
    private final String name;
    private final String primaryDataSourceName;
    private final List<String> replicaDataSourceNames;
    private final ReplicaLoadBalanceAlgorithm loadBalancer;
    private final Collection<String> disabledDataSourceNames = new HashSet<String>();

    public ReplicaQueryDataSourceRule(ReplicaQueryDataSourceRuleConfiguration config, ReplicaLoadBalanceAlgorithm loadBalancer) {
        this.checkConfiguration(config);
        this.name = config.getName();
        this.primaryDataSourceName = config.getPrimaryDataSourceName();
        this.replicaDataSourceNames = config.getReplicaDataSourceNames();
        this.loadBalancer = loadBalancer;
    }

    private void checkConfiguration(ReplicaQueryDataSourceRuleConfiguration config) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getName()) ? 1 : 0) != 0, (Object)"Name is required.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)config.getPrimaryDataSourceName()) ? 1 : 0) != 0, (Object)"Primary data source name is required.");
        Preconditions.checkArgument((null != config.getReplicaDataSourceNames() && !config.getReplicaDataSourceNames().isEmpty() ? 1 : 0) != 0, (Object)"Replica data source names are required.");
    }

    public List<String> getReplicaDataSourceNames() {
        return this.replicaDataSourceNames.stream().filter(each -> !this.disabledDataSourceNames.contains(each)).collect(Collectors.toList());
    }

    public void updateDisabledDataSourceNames(String dataSourceName, boolean isDisabled) {
        if (isDisabled) {
            this.disabledDataSourceNames.add(dataSourceName);
        } else {
            this.disabledDataSourceNames.remove(dataSourceName);
        }
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(1, 1.0f);
        LinkedList<String> actualDataSourceNames = new LinkedList<String>();
        actualDataSourceNames.add(this.primaryDataSourceName);
        actualDataSourceNames.addAll(this.replicaDataSourceNames);
        result.put(this.name, actualDataSourceNames);
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPrimaryDataSourceName() {
        return this.primaryDataSourceName;
    }

    @Generated
    public ReplicaLoadBalanceAlgorithm getLoadBalancer() {
        return this.loadBalancer;
    }
}

