/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.rule;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.TypedSPIConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmFactory;
import org.apache.shardingsphere.infra.rule.DataSourceRoutedRule;
import org.apache.shardingsphere.infra.rule.StatusContainedRule;
import org.apache.shardingsphere.infra.rule.event.RuleChangedEvent;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.typed.TypedSPIRegistry;
import org.apache.shardingsphere.replicaquery.algorithm.config.AlgorithmProvidedReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.api.config.ReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.api.config.rule.ReplicaQueryDataSourceRuleConfiguration;
import org.apache.shardingsphere.replicaquery.rule.ReplicaQueryDataSourceRule;
import org.apache.shardingsphere.replicaquery.spi.ReplicaLoadBalanceAlgorithm;

public final class ReplicaQueryRule
implements DataSourceRoutedRule,
StatusContainedRule {
    private final Map<String, ReplicaLoadBalanceAlgorithm> loadBalancers = new LinkedHashMap<String, ReplicaLoadBalanceAlgorithm>();
    private final Map<String, ReplicaQueryDataSourceRule> dataSourceRules;

    public ReplicaQueryRule(ReplicaQueryRuleConfiguration config) {
        Preconditions.checkArgument((!config.getDataSources().isEmpty() ? 1 : 0) != 0, (Object)"Replica query data source rules can not be empty.");
        config.getLoadBalancers().forEach((key, value) -> this.loadBalancers.put((String)key, (ReplicaLoadBalanceAlgorithm)ShardingSphereAlgorithmFactory.createAlgorithm((TypedSPIConfiguration)value, ReplicaLoadBalanceAlgorithm.class)));
        this.dataSourceRules = new HashMap<String, ReplicaQueryDataSourceRule>(config.getDataSources().size(), 1.0f);
        for (ReplicaQueryDataSourceRuleConfiguration each : config.getDataSources()) {
            ReplicaLoadBalanceAlgorithm loadBalanceAlgorithm = Strings.isNullOrEmpty((String)each.getLoadBalancerName()) || !this.loadBalancers.containsKey(each.getLoadBalancerName()) ? (ReplicaLoadBalanceAlgorithm)TypedSPIRegistry.getRegisteredService(ReplicaLoadBalanceAlgorithm.class) : this.loadBalancers.get(each.getLoadBalancerName());
            this.dataSourceRules.put(each.getName(), new ReplicaQueryDataSourceRule(each, loadBalanceAlgorithm));
        }
    }

    public ReplicaQueryRule(AlgorithmProvidedReplicaQueryRuleConfiguration config) {
        Preconditions.checkArgument((!config.getDataSources().isEmpty() ? 1 : 0) != 0, (Object)"Replica query data source rules can not be empty.");
        this.loadBalancers.putAll(config.getLoadBalanceAlgorithms());
        this.dataSourceRules = new HashMap<String, ReplicaQueryDataSourceRule>(config.getDataSources().size(), 1.0f);
        for (ReplicaQueryDataSourceRuleConfiguration each : config.getDataSources()) {
            ReplicaLoadBalanceAlgorithm loadBalanceAlgorithm = Strings.isNullOrEmpty((String)each.getLoadBalancerName()) || !this.loadBalancers.containsKey(each.getLoadBalancerName()) ? (ReplicaLoadBalanceAlgorithm)TypedSPIRegistry.getRegisteredService(ReplicaLoadBalanceAlgorithm.class) : this.loadBalancers.get(each.getLoadBalancerName());
            this.dataSourceRules.put(each.getName(), new ReplicaQueryDataSourceRule(each, loadBalanceAlgorithm));
        }
    }

    public Collection<String> getAllLogicDataSourceNames() {
        return this.dataSourceRules.keySet();
    }

    public ReplicaQueryDataSourceRule getSingleDataSourceRule() {
        return this.dataSourceRules.values().iterator().next();
    }

    public Optional<ReplicaQueryDataSourceRule> findDataSourceRule(String dataSourceName) {
        return Optional.ofNullable(this.dataSourceRules.get(dataSourceName));
    }

    public Map<String, Collection<String>> getDataSourceMapper() {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, ReplicaQueryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
            result.putAll(entry.getValue().getDataSourceMapper());
        }
        return result;
    }

    public void updateRuleStatus(RuleChangedEvent event) {
        if (event instanceof DataSourceNameDisabledEvent) {
            for (Map.Entry<String, ReplicaQueryDataSourceRule> entry : this.dataSourceRules.entrySet()) {
                entry.getValue().updateDisabledDataSourceNames(((DataSourceNameDisabledEvent)event).getDataSourceName(), ((DataSourceNameDisabledEvent)event).isDisabled());
            }
        }
    }

    static {
        ShardingSphereServiceLoader.register(ReplicaLoadBalanceAlgorithm.class);
    }
}

