/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.replicaquery.spring.boot;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.replicaquery.algorithm.config.AlgorithmProvidedReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.spi.ReplicaLoadBalanceAlgorithm;
import org.apache.shardingsphere.replicaquery.spring.boot.algorithm.ReplicaQueryAlgorithmProvidedBeanRegistry;
import org.apache.shardingsphere.replicaquery.spring.boot.condition.ReplicaQuerySpringBootCondition;
import org.apache.shardingsphere.replicaquery.spring.boot.rule.YamlReplicaQueryRuleSpringBootConfiguration;
import org.apache.shardingsphere.replicaquery.yaml.config.YamlReplicaQueryRuleConfiguration;
import org.apache.shardingsphere.replicaquery.yaml.swapper.ReplicaQueryRuleAlgorithmProviderConfigurationYamlSwapper;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@EnableConfigurationProperties(value={YamlReplicaQueryRuleSpringBootConfiguration.class})
@ConditionalOnClass(value={YamlReplicaQueryRuleConfiguration.class})
@Conditional(value={ReplicaQuerySpringBootCondition.class})
public class ReplicaQueryRuleSpringbootConfiguration {
    private final ReplicaQueryRuleAlgorithmProviderConfigurationYamlSwapper swapper = new ReplicaQueryRuleAlgorithmProviderConfigurationYamlSwapper();
    private final YamlReplicaQueryRuleSpringBootConfiguration yamlConfig;

    @Bean
    public RuleConfiguration replicaQueryRuleConfiguration(ObjectProvider<Map<String, ReplicaLoadBalanceAlgorithm>> loadBalanceAlgorithms) {
        AlgorithmProvidedReplicaQueryRuleConfiguration result = this.swapper.swapToObject(this.yamlConfig.getReplicaQuery());
        Map balanceAlgorithmMap = Optional.ofNullable(loadBalanceAlgorithms.getIfAvailable()).orElse(Collections.emptyMap());
        result.setLoadBalanceAlgorithms(balanceAlgorithmMap);
        return result;
    }

    @Bean
    public static ReplicaQueryAlgorithmProvidedBeanRegistry replicaQueryAlgorithmProvidedBeanRegistry(Environment environment) {
        return new ReplicaQueryAlgorithmProvidedBeanRegistry(environment);
    }

    @Generated
    public ReplicaQueryRuleSpringbootConfiguration(YamlReplicaQueryRuleSpringBootConfiguration yamlConfig) {
        this.yamlConfig = yamlConfig;
    }
}

