/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.parser.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.ShadowDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.ShadowDistSQLStatementParser;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.parser.segment.ShadowRuleSegment;
import org.apache.shardingsphere.shadow.distsql.parser.statement.AlterShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.AlterShadowRuleStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.CreateDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.CreateShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.CreateShadowRuleStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.DropDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.DropShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.DropShadowRuleStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.ShowShadowAlgorithmsStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.ShowShadowRulesStatement;
import org.apache.shardingsphere.shadow.distsql.parser.statement.ShowShadowTableRulesStatement;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class ShadowDistSQLStatementVisitor
extends ShadowDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor {
    @Override
    public ASTNode visitCreateShadowRule(ShadowDistSQLStatementParser.CreateShadowRuleContext ctx) {
        List shadowRuleSegments = ctx.shadowRuleDefinition().stream().map(arg_0 -> ((ShadowDistSQLStatementVisitor)this).visit(arg_0)).map(each -> (ShadowRuleSegment)each).collect(Collectors.toList());
        return new CreateShadowRuleStatement(shadowRuleSegments);
    }

    @Override
    public ASTNode visitCreateDefaultShadowAlgorithm(ShadowDistSQLStatementParser.CreateDefaultShadowAlgorithmContext ctx) {
        return new CreateDefaultShadowAlgorithmStatement(this.getIdentifierValue(ctx.algorithmName()));
    }

    @Override
    public ASTNode visitShadowRuleDefinition(ShadowDistSQLStatementParser.ShadowRuleDefinitionContext ctx) {
        Map<String, Collection> shadowAlgorithms = ctx.shadowTableRule().stream().collect(Collectors.toMap(each -> this.getIdentifierValue(each.tableName()), each -> this.visitShadowAlgorithms(each.shadowAlgorithmDefinition())));
        return new ShadowRuleSegment(this.getIdentifierValue(ctx.ruleName()), this.getIdentifierValue(ctx.source()), this.getIdentifierValue(ctx.shadow()), shadowAlgorithms);
    }

    @Override
    public ASTNode visitShowShadowAlgorithms(ShadowDistSQLStatementParser.ShowShadowAlgorithmsContext ctx) {
        return new ShowShadowAlgorithmsStatement(null != ctx.databaseName() ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    @Override
    public ASTNode visitShadowAlgorithmDefinition(ShadowDistSQLStatementParser.ShadowAlgorithmDefinitionContext ctx) {
        AlgorithmSegment segment = new AlgorithmSegment(this.getIdentifierValue(ctx.shadowAlgorithmType()), this.getAlgorithmProperties(ctx.algorithmProperties()));
        String algorithmName = null != ctx.algorithmName() ? this.getIdentifierValue(ctx.algorithmName()) : this.createAlgorithmName(this.getIdentifierValue(((ShadowDistSQLStatementParser.ShadowRuleDefinitionContext)ctx.getParent().getParent()).ruleName()), this.getIdentifierValue(((ShadowDistSQLStatementParser.ShadowTableRuleContext)ctx.getParent()).tableName()), segment);
        return new ShadowAlgorithmSegment(algorithmName, segment);
    }

    private Properties getAlgorithmProperties(ShadowDistSQLStatementParser.AlgorithmPropertiesContext ctx) {
        Properties result = new Properties();
        ctx.algorithmProperty().forEach(each -> result.put(IdentifierValue.getQuotedContent((String)each.key.getText()), IdentifierValue.getQuotedContent((String)each.value.getText())));
        return result;
    }

    @Override
    public ASTNode visitAlterShadowRule(ShadowDistSQLStatementParser.AlterShadowRuleContext ctx) {
        List shadowRuleSegments = ctx.shadowRuleDefinition().stream().map(arg_0 -> ((ShadowDistSQLStatementVisitor)this).visit(arg_0)).map(each -> (ShadowRuleSegment)each).collect(Collectors.toList());
        return new AlterShadowRuleStatement(shadowRuleSegments);
    }

    @Override
    public ASTNode visitCreateShadowAlgorithm(ShadowDistSQLStatementParser.CreateShadowAlgorithmContext ctx) {
        return new CreateShadowAlgorithmStatement(this.visitShadowAlgorithms(ctx.shadowAlgorithmDefinition()));
    }

    @Override
    public ASTNode visitDropShadowRule(ShadowDistSQLStatementParser.DropShadowRuleContext ctx) {
        return new DropShadowRuleStatement(null != ctx.existClause(), (Collection)ctx.ruleName().stream().map(each -> new IdentifierValue(each.getText()).getValue()).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterShadowAlgorithm(ShadowDistSQLStatementParser.AlterShadowAlgorithmContext ctx) {
        return new AlterShadowAlgorithmStatement(this.visitShadowAlgorithms(ctx.shadowAlgorithmDefinition()));
    }

    @Override
    public ASTNode visitDropShadowAlgorithm(ShadowDistSQLStatementParser.DropShadowAlgorithmContext ctx) {
        return new DropShadowAlgorithmStatement(null != ctx.existClause(), null == ctx.algorithmName() ? Collections.emptyList() : (Collection)ctx.algorithmName().stream().map(this::getIdentifierValue).collect(Collectors.toSet()));
    }

    @Override
    public ASTNode visitDropDefaultShadowAlgorithm(ShadowDistSQLStatementParser.DropDefaultShadowAlgorithmContext ctx) {
        return new DropDefaultShadowAlgorithmStatement(null != ctx.existClause());
    }

    @Override
    public ASTNode visitShowShadowRules(ShadowDistSQLStatementParser.ShowShadowRulesContext ctx) {
        String ruleName = null == ctx.shadowRule() ? null : this.getIdentifierValue(ctx.shadowRule().ruleName());
        DatabaseSegment databaseSegment = null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName());
        return new ShowShadowRulesStatement(ruleName, null == ctx.databaseName() ? null : databaseSegment);
    }

    @Override
    public ASTNode visitShowShadowTableRules(ShadowDistSQLStatementParser.ShowShadowTableRulesContext ctx) {
        return new ShowShadowTableRulesStatement(null != ctx.databaseName() ? (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()) : null);
    }

    private String getIdentifierValue(ParserRuleContext ctx) {
        if (null == ctx || ctx.isEmpty()) {
            return null;
        }
        return new IdentifierValue(ctx.getText()).getValue();
    }

    private Collection<ShadowAlgorithmSegment> visitShadowAlgorithms(List<ShadowDistSQLStatementParser.ShadowAlgorithmDefinitionContext> ctxs) {
        return ctxs.stream().map(arg_0 -> ((ShadowDistSQLStatementVisitor)this).visit(arg_0)).map(each -> (ShadowAlgorithmSegment)each).collect(Collectors.toList());
    }

    private String createAlgorithmName(String ruleName, String tableName, AlgorithmSegment algorithmSegment) {
        return String.format("%s_%s_%s", ruleName, tableName, algorithmSegment.getName()).toLowerCase();
    }

    @Override
    public ASTNode visitDatabaseName(ShadowDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }
}

