/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.route.engine;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.infra.binder.LogicSQL;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.route.SQLRouter;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.schema.ShardingSphereSchema;
import org.apache.shardingsphere.shadow.route.engine.judge.ShadowDataSourceJudgeEngine;
import org.apache.shardingsphere.shadow.route.engine.judge.impl.PreparedShadowDataSourceJudgeEngine;
import org.apache.shardingsphere.shadow.route.engine.judge.impl.SimpleShadowDataSourceJudgeEngine;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.DMLStatement;

public final class ShadowSQLRouter
implements SQLRouter<ShadowRule> {
    public RouteContext createRouteContext(LogicSQL logicSQL, ShardingSphereSchema schema, ShadowRule rule, ConfigurationProperties props) {
        RouteContext result = new RouteContext();
        if (!(logicSQL.getSqlStatementContext().getSqlStatement() instanceof DMLStatement)) {
            rule.getShadowMappings().forEach((key, value) -> {
                result.getRouteUnits().add(new RouteUnit(new RouteMapper(key, key), Collections.emptyList()));
                result.getRouteUnits().add(new RouteUnit(new RouteMapper(value, value), Collections.emptyList()));
            });
            return result;
        }
        if (this.isShadow(logicSQL.getSqlStatementContext(), logicSQL.getParameters(), rule)) {
            rule.getShadowMappings().values().forEach(each -> result.getRouteUnits().add(new RouteUnit(new RouteMapper(each, each), Collections.emptyList())));
        } else {
            rule.getShadowMappings().keySet().forEach(each -> result.getRouteUnits().add(new RouteUnit(new RouteMapper(each, each), Collections.emptyList())));
        }
        return result;
    }

    public void decorateRouteContext(RouteContext routeContext, LogicSQL logicSQL, ShardingSphereSchema schema, ShadowRule rule, ConfigurationProperties props) {
        LinkedList<RouteUnit> toBeAdded = new LinkedList<RouteUnit>();
        if (!(logicSQL.getSqlStatementContext().getSqlStatement() instanceof DMLStatement)) {
            for (RouteUnit each : routeContext.getRouteUnits()) {
                String shadowDataSourceName = (String)rule.getShadowMappings().get(each.getDataSourceMapper().getActualName());
                toBeAdded.add(new RouteUnit(new RouteMapper(each.getDataSourceMapper().getLogicName(), shadowDataSourceName), each.getTableMappers()));
            }
            routeContext.getRouteUnits().addAll(toBeAdded);
            return;
        }
        LinkedList<RouteUnit> toBeRemoved = new LinkedList<RouteUnit>();
        if (this.isShadow(logicSQL.getSqlStatementContext(), logicSQL.getParameters(), rule)) {
            for (RouteUnit each : routeContext.getRouteUnits()) {
                toBeRemoved.add(each);
                String shadowDataSourceName = (String)rule.getShadowMappings().get(each.getDataSourceMapper().getActualName());
                toBeAdded.add(new RouteUnit(new RouteMapper(each.getDataSourceMapper().getLogicName(), shadowDataSourceName), each.getTableMappers()));
            }
        }
        routeContext.getRouteUnits().removeAll(toBeRemoved);
        routeContext.getRouteUnits().addAll(toBeAdded);
    }

    private boolean isShadow(SQLStatementContext<?> sqlStatementContext, List<Object> parameters, ShadowRule rule) {
        ShadowDataSourceJudgeEngine shadowDataSourceRouter = parameters.isEmpty() ? new SimpleShadowDataSourceJudgeEngine(rule, sqlStatementContext) : new PreparedShadowDataSourceJudgeEngine(rule, sqlStatementContext, parameters);
        return shadowDataSourceRouter.isShadow();
    }

    public int getOrder() {
        return 60;
    }

    public Class<ShadowRule> getTypeClass() {
        return ShadowRule.class;
    }
}

