/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Properties;
import me.ahoo.cosid.util.LocalDateTimeConvert;
import org.apache.shardingsphere.sharding.cosid.algorithm.sharding.interval.AbstractCosIdIntervalShardingAlgorithm;

public final class CosIdIntervalShardingAlgorithm
extends AbstractCosIdIntervalShardingAlgorithm<Comparable<?>> {
    public static final String TYPE = "COSID_INTERVAL";
    public static final String DATE_TIME_PATTERN_KEY = "datetime-pattern";
    public static final String TIMESTAMP_SECOND_UNIT = "SECOND";
    public static final String TIMESTAMP_UNIT_KEY = "ts-unit";
    private boolean isSecondTs;
    private DateTimeFormatter dateTimeFormatter;

    @Override
    public void init(Properties props) {
        super.init(props);
        this.isSecondTs = this.getIsSecondTs(props);
        this.dateTimeFormatter = this.getDateTimeFormatter(props);
    }

    private boolean getIsSecondTs(Properties props) {
        return props.containsKey(TIMESTAMP_UNIT_KEY) && TIMESTAMP_SECOND_UNIT.equalsIgnoreCase(props.getProperty(TIMESTAMP_UNIT_KEY));
    }

    private DateTimeFormatter getDateTimeFormatter(Properties props) {
        return DateTimeFormatter.ofPattern(props.getProperty(DATE_TIME_PATTERN_KEY, "yyyy-MM-dd HH:mm:ss"));
    }

    @Override
    protected LocalDateTime convertShardingValue(Comparable<?> shardingValue) {
        if (shardingValue instanceof LocalDateTime) {
            return (LocalDateTime)shardingValue;
        }
        if (shardingValue instanceof Date) {
            return LocalDateTimeConvert.fromDate((Date)((Date)shardingValue), (ZoneId)this.getZoneId());
        }
        if (shardingValue instanceof Long) {
            return this.isSecondTs ? LocalDateTimeConvert.fromTimestampSecond((Long)((Long)shardingValue), (ZoneId)this.getZoneId()) : LocalDateTimeConvert.fromTimestamp((Long)((Long)shardingValue), (ZoneId)this.getZoneId());
        }
        if (shardingValue instanceof String) {
            return LocalDateTimeConvert.fromString((String)((String)((Object)shardingValue)), (DateTimeFormatter)this.dateTimeFormatter);
        }
        throw new IllegalArgumentException(Strings.lenientFormat((String)"The current shard type:[%s] is not supported!", (Object[])new Object[]{shardingValue.getClass()}));
    }

    public String getType() {
        return TYPE;
    }
}

