/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredAlgorithmMissedException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyLevelType;
import org.apache.shardingsphere.sharding.distsql.handler.enums.ShardingStrategyType;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateDefaultShardingStrategyStatement;

public final class CreateDefaultShardingStrategyStatementUpdater
implements RuleDefinitionCreateUpdater<CreateDefaultShardingStrategyStatement, ShardingRuleConfiguration> {
    private static final String TYPE = CreateDefaultShardingStrategyStatement.class.getName();

    public void checkSQLStatement(ShardingSphereDatabase database, CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        String databaseName = database.getName();
        this.checkCurrentRuleConfiguration(databaseName, currentRuleConfig);
        this.checkAlgorithm(databaseName, currentRuleConfig, sqlStatement);
        this.checkExist(databaseName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentRuleConfiguration(String databaseName, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((null != currentRuleConfig ? 1 : 0) != 0, () -> new RequiredRuleMissedException("Sharding", databaseName));
    }

    private void checkAlgorithm(String databaseName, ShardingRuleConfiguration currentRuleConfig, CreateDefaultShardingStrategyStatement sqlStatement) throws DistSQLException {
        DistSQLException.predictionThrow((boolean)ShardingStrategyType.contain(sqlStatement.getStrategyType()), () -> new InvalidAlgorithmConfigurationException(sqlStatement.getStrategyType()));
        DistSQLException.predictionThrow((boolean)ShardingStrategyType.getValueOf(sqlStatement.getStrategyType()).isValid(sqlStatement.getShardingColumn()), () -> new InvalidAlgorithmConfigurationException(sqlStatement.getStrategyType()));
        DistSQLException.predictionThrow((boolean)this.isAlgorithmDefinitionExists(sqlStatement), RequiredAlgorithmMissedException::new);
        if (null == sqlStatement.getShardingAlgorithmName() && null != sqlStatement.getAlgorithmSegment()) {
            return;
        }
        boolean isAlgorithmExist = currentRuleConfig.getShardingAlgorithms().containsKey(sqlStatement.getShardingAlgorithmName());
        DistSQLException.predictionThrow((boolean)isAlgorithmExist, () -> new RequiredAlgorithmMissedException(databaseName, Collections.singleton(sqlStatement.getShardingAlgorithmName())));
    }

    private boolean isAlgorithmDefinitionExists(CreateDefaultShardingStrategyStatement sqlStatement) {
        return null != sqlStatement.getShardingAlgorithmName() || null != sqlStatement.getAlgorithmSegment();
    }

    private void checkExist(String databaseName, CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Optional<ShardingStrategyConfiguration> strategyConfig = this.getStrategyConfiguration(currentRuleConfig, sqlStatement.getDefaultType());
        DistSQLException.predictionThrow((!strategyConfig.isPresent() ? 1 : 0) != 0, () -> new DuplicateRuleException(String.format("default sharding %s strategy", sqlStatement.getDefaultType().toLowerCase()), databaseName));
    }

    private Optional<ShardingStrategyConfiguration> getStrategyConfiguration(ShardingRuleConfiguration currentRuleConfig, String type) {
        ShardingStrategyConfiguration result = type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name()) ? currentRuleConfig.getDefaultTableShardingStrategy() : currentRuleConfig.getDefaultDatabaseShardingStrategy();
        return Optional.ofNullable(result);
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateDefaultShardingStrategyStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        String shardingAlgorithmName = this.getShardingAlgorithmName(sqlStatement, result);
        ShardingStrategyConfiguration strategyConfig = ShardingTableRuleStatementConverter.createStrategyConfiguration(sqlStatement.getStrategyType(), sqlStatement.getShardingColumn(), shardingAlgorithmName);
        this.setStrategyConfiguration(result, sqlStatement.getDefaultType(), strategyConfig);
        return result;
    }

    private String getShardingAlgorithmName(CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration ruleConfig) {
        return null == sqlStatement.getShardingAlgorithmName() ? this.createDefaultAlgorithm(sqlStatement, ruleConfig) : sqlStatement.getShardingAlgorithmName();
    }

    private String createDefaultAlgorithm(CreateDefaultShardingStrategyStatement sqlStatement, ShardingRuleConfiguration ruleConfig) {
        String result = this.getDefaultShardingAlgorithmName(sqlStatement.getDefaultType(), sqlStatement.getAlgorithmSegment().getName());
        ruleConfig.getShardingAlgorithms().put(result, this.createAlgorithmConfiguration(sqlStatement.getAlgorithmSegment()));
        return result;
    }

    private ShardingSphereAlgorithmConfiguration createAlgorithmConfiguration(AlgorithmSegment segment) {
        return new ShardingSphereAlgorithmConfiguration(segment.getName(), segment.getProps());
    }

    private String getDefaultShardingAlgorithmName(String defaultType, String algorithmType) {
        return String.format("default_%s_%s", defaultType.toLowerCase(), algorithmType);
    }

    private void setStrategyConfiguration(ShardingRuleConfiguration ruleConfig, String type, ShardingStrategyConfiguration shardingStrategyConfig) {
        if (type.equalsIgnoreCase(ShardingStrategyLevelType.TABLE.name())) {
            ruleConfig.setDefaultTableShardingStrategy(shardingStrategyConfig);
        } else {
            ruleConfig.setDefaultDatabaseShardingStrategy(shardingStrategyConfig);
        }
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeCreatedRuleConfig) {
        if (!toBeCreatedRuleConfig.getShardingAlgorithms().isEmpty()) {
            currentRuleConfig.getShardingAlgorithms().putAll(toBeCreatedRuleConfig.getShardingAlgorithms());
        }
        if (null != toBeCreatedRuleConfig.getDefaultTableShardingStrategy() && null == currentRuleConfig.getDefaultTableShardingStrategy()) {
            currentRuleConfig.setDefaultTableShardingStrategy(toBeCreatedRuleConfig.getDefaultTableShardingStrategy());
        }
        if (null != toBeCreatedRuleConfig.getDefaultDatabaseShardingStrategy() && null == currentRuleConfig.getDefaultDatabaseShardingStrategy()) {
            currentRuleConfig.setDefaultDatabaseShardingStrategy(toBeCreatedRuleConfig.getDefaultDatabaseShardingStrategy());
        }
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return TYPE;
    }
}

