/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.broadcast;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.TableRule;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;

public final class ShardingTableBroadcastRoutingEngine
implements ShardingRouteEngine {
    private final PhysicalSchemaMetaData schemaMetaData;
    private final SQLStatementContext sqlStatementContext;

    @Override
    public void route(RouteContext routeContext, ShardingRule shardingRule) {
        for (String each : this.getLogicTableNames()) {
            routeContext.getRouteUnits().addAll(this.getAllRouteUnits(shardingRule, each));
        }
    }

    private Collection<String> getLogicTableNames() {
        return this.sqlStatementContext.getSqlStatement() instanceof DropIndexStatement && !((DropIndexStatement)this.sqlStatementContext.getSqlStatement()).getIndexes().isEmpty() ? this.getTableNamesFromMetaData((DropIndexStatement)this.sqlStatementContext.getSqlStatement()) : this.sqlStatementContext.getTablesContext().getTableNames();
    }

    private Collection<String> getTableNamesFromMetaData(DropIndexStatement dropIndexStatement) {
        LinkedList<String> result = new LinkedList<String>();
        for (IndexSegment each : dropIndexStatement.getIndexes()) {
            Optional<String> tableName = this.findLogicTableNameFromMetaData(each.getIdentifier().getValue());
            Preconditions.checkState((boolean)tableName.isPresent(), (String)"Cannot find index name `%s`.", (Object)each.getIdentifier().getValue());
            result.add(tableName.get());
        }
        return result;
    }

    private Optional<String> findLogicTableNameFromMetaData(String logicIndexName) {
        for (String each : this.schemaMetaData.getAllTableNames()) {
            if (!this.schemaMetaData.get(each).getIndexes().containsKey(logicIndexName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private Collection<RouteUnit> getAllRouteUnits(ShardingRule shardingRule, String logicTableName) {
        LinkedList<RouteUnit> result = new LinkedList<RouteUnit>();
        TableRule tableRule = shardingRule.getTableRule(logicTableName);
        for (DataNode each : tableRule.getActualDataNodes()) {
            RouteUnit routeUnit = new RouteUnit(new RouteMapper(each.getDataSourceName(), each.getDataSourceName()), Collections.singletonList(new RouteMapper(logicTableName, each.getTableName())));
            result.add(routeUnit);
        }
        return result;
    }

    @Generated
    public ShardingTableBroadcastRoutingEngine(PhysicalSchemaMetaData schemaMetaData, SQLStatementContext sqlStatementContext) {
        this.schemaMetaData = schemaMetaData;
        this.sqlStatementContext = sqlStatementContext;
    }
}

