/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.type.unconfigured;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.infra.route.context.RouteMapper;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.sharding.route.engine.type.ShardingRouteEngine;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class ShardingUnconfiguredTablesRoutingEngine
implements ShardingRouteEngine {
    private final Collection<String> logicTables;
    private final Map<String, Collection<String>> unconfiguredSchemaMetaDataMap;
    private final SQLStatement sqlStatement;

    @Override
    public void route(RouteContext routeContext, ShardingRule shardingRule) {
        Optional<String> dataSourceName;
        Optional<String> optional = dataSourceName = this.sqlStatement instanceof CreateTableStatement ? this.getRandomDataSourceName(shardingRule.getDataSourceNames()) : this.findDataSourceName();
        if (!dataSourceName.isPresent()) {
            throw new ShardingSphereException("Can not route tables for `%s`, please make sure the tables are in same schema.", new Object[]{this.logicTables});
        }
        List routingTables = this.logicTables.stream().map(table -> new RouteMapper(table, table)).collect(Collectors.toList());
        routeContext.getRouteUnits().add(new RouteUnit(new RouteMapper(dataSourceName.get(), dataSourceName.get()), routingTables));
    }

    private Optional<String> findDataSourceName() {
        for (Map.Entry<String, Collection<String>> entry : this.unconfiguredSchemaMetaDataMap.entrySet()) {
            if (!entry.getValue().containsAll(this.logicTables)) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    private Optional<String> getRandomDataSourceName(Collection<String> dataSourceNames) {
        String dataSourceName = (String)Lists.newArrayList(dataSourceNames).get(ThreadLocalRandom.current().nextInt(dataSourceNames.size()));
        return Optional.of(dataSourceName);
    }

    @Generated
    public ShardingUnconfiguredTablesRoutingEngine(Collection<String> logicTables, Map<String, Collection<String>> unconfiguredSchemaMetaDataMap, SQLStatement sqlStatement) {
        this.logicTables = logicTables;
        this.unconfiguredSchemaMetaDataMap = unconfiguredSchemaMetaDataMap;
        this.sqlStatement = sqlStatement;
    }
}

