/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl;

import java.util.Collection;
import java.util.Map;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.route.engine.exception.NoSuchTableException;
import org.apache.shardingsphere.sharding.route.engine.exception.TableExistsException;
import org.apache.shardingsphere.sharding.route.engine.validator.ShardingStatementValidator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DDLStatement;

public abstract class ShardingDDLStatementValidator<T extends DDLStatement>
implements ShardingStatementValidator<T> {
    protected void validateShardingTable(ShardingSphereMetaData metaData, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            if (!metaData.getSchemaMetaData().getConfiguredSchemaMetaData().getAllTableNames().contains(tableName)) continue;
            throw new ShardingSphereException("Can not support sharding table '%s'.", new Object[]{tableName});
        }
    }

    protected void validateTableExist(ShardingSphereMetaData metaData, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            for (Map.Entry entry : metaData.getSchemaMetaData().getUnconfiguredSchemaMetaDataMap().entrySet()) {
                if (((Collection)entry.getValue()).contains(tableName)) continue;
                throw new NoSuchTableException((String)entry.getKey(), tableName);
            }
        }
    }

    protected void validateTableNotExist(ShardingSphereMetaData metaData, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            String tableName = each.getTableName().getIdentifier().getValue();
            if (!metaData.getSchemaMetaData().getAllTableNames().contains(tableName)) continue;
            throw new TableExistsException(tableName);
        }
    }
}

