/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.visitor;

import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.apache.shardingsphere.sql.parser.core.visitor.SQLVisitorFacadeRegistry;
import org.apache.shardingsphere.sql.parser.core.visitor.SQLVisitorRule;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.spi.SQLVisitorFacade;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatementType;

public final class SQLVisitorFactory {
    public static <T> ParseTreeVisitor<T> newInstance(String databaseType, String visitorType, SQLVisitorRule visitorRule) {
        SQLVisitorFacade facade = SQLVisitorFacadeRegistry.getInstance().getSQLVisitorFacade(databaseType, visitorType);
        return SQLVisitorFactory.createParseTreeVisitor(facade, visitorRule.getType());
    }

    private static <T> ParseTreeVisitor<T> createParseTreeVisitor(SQLVisitorFacade visitorFacade, SQLStatementType type) {
        switch (type) {
            case DML: {
                return (ParseTreeVisitor)visitorFacade.getDMLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case DDL: {
                return (ParseTreeVisitor)visitorFacade.getDDLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case TCL: {
                return (ParseTreeVisitor)visitorFacade.getTCLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case DCL: {
                return (ParseTreeVisitor)visitorFacade.getDCLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case DAL: {
                return (ParseTreeVisitor)visitorFacade.getDALVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            case RL: {
                return (ParseTreeVisitor)visitorFacade.getRLVisitorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        throw new SQLParsingException("Can not support SQL statement type: `%s`", type);
    }

    @Generated
    private SQLVisitorFactory() {
    }
}

