/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.api;

import com.google.common.cache.LoadingCache;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.CacheOption;
import org.apache.shardingsphere.sql.parser.core.cache.ParseTreeCacheBuilder;
import org.apache.shardingsphere.sql.parser.core.parser.SQLParserExecutor;

public final class SQLParserEngine {
    private final SQLParserExecutor sqlParserExecutor;
    private final LoadingCache<String, ParseTree> parseTreeCache;

    public SQLParserEngine(String databaseType) {
        this(databaseType, new CacheOption(128, 1024L, 4));
    }

    public SQLParserEngine(String databaseType, CacheOption cacheOption) {
        this.sqlParserExecutor = new SQLParserExecutor(databaseType);
        this.parseTreeCache = ParseTreeCacheBuilder.build(cacheOption, databaseType);
    }

    public ParseTree parse(String sql, boolean useCache) {
        return useCache ? (ParseTree)this.parseTreeCache.getUnchecked((Object)sql) : this.sqlParserExecutor.parse(sql);
    }
}

