/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.statement.impl;

import java.util.Optional;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DCLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;
import org.apache.shardingsphere.sql.parser.mysql.visitor.statement.impl.MySQLStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLAlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLCreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLCreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLDropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLDropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLGrantStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLRenameUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLRevokeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLSetDefaultRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLSetPasswordStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dcl.MySQLSetRoleStatement;

public final class MySQLDCLStatementSQLVisitor
extends MySQLStatementSQLVisitor
implements DCLSQLVisitor,
SQLStatementVisitor {
    @Override
    public ASTNode visitGrant(MySQLStatementParser.GrantContext ctx) {
        MySQLGrantStatement result = new MySQLGrantStatement();
        Optional<SimpleTableSegment> tableSegmentOptional = null == ctx.privilegeClause() ? Optional.empty() : this.getTableFromPrivilegeClause(ctx.privilegeClause());
        tableSegmentOptional.ifPresent(tableSegment -> result.getTables().add(tableSegment));
        return result;
    }

    @Override
    public ASTNode visitRevoke(MySQLStatementParser.RevokeContext ctx) {
        MySQLRevokeStatement result = new MySQLRevokeStatement();
        Optional<SimpleTableSegment> tableSegmentOptional = null == ctx.privilegeClause() ? Optional.empty() : this.getTableFromPrivilegeClause(ctx.privilegeClause());
        tableSegmentOptional.ifPresent(tableSegment -> result.getTables().add(tableSegment));
        return result;
    }

    private Optional<SimpleTableSegment> getTableFromPrivilegeClause(MySQLStatementParser.PrivilegeClauseContext ctx) {
        MySQLStatementParser.TableNameContext tableName;
        if (null != ctx.onObjectClause() && null != (tableName = ctx.onObjectClause().privilegeLevel().tableName())) {
            return Optional.of((SimpleTableSegment)this.visitTableName(tableName));
        }
        return Optional.empty();
    }

    @Override
    public ASTNode visitCreateUser(MySQLStatementParser.CreateUserContext ctx) {
        return new MySQLCreateUserStatement();
    }

    @Override
    public ASTNode visitDropUser(MySQLStatementParser.DropUserContext ctx) {
        return new MySQLDropUserStatement();
    }

    @Override
    public ASTNode visitAlterUser(MySQLStatementParser.AlterUserContext ctx) {
        return new MySQLAlterUserStatement();
    }

    @Override
    public ASTNode visitRenameUser(MySQLStatementParser.RenameUserContext ctx) {
        return new MySQLRenameUserStatement();
    }

    @Override
    public ASTNode visitCreateRole(MySQLStatementParser.CreateRoleContext ctx) {
        return new MySQLCreateRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(MySQLStatementParser.DropRoleContext ctx) {
        return new MySQLDropRoleStatement();
    }

    @Override
    public ASTNode visitSetDefaultRole(MySQLStatementParser.SetDefaultRoleContext ctx) {
        return new MySQLSetDefaultRoleStatement();
    }

    @Override
    public ASTNode visitSetRole(MySQLStatementParser.SetRoleContext ctx) {
        return new MySQLSetRoleStatement();
    }

    @Override
    public ASTNode visitSetPassword(MySQLStatementParser.SetPasswordContext ctx) {
        return new MySQLSetPasswordStatement();
    }
}

