/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.V2RequestSupport;
import org.apache.solr.client.solrj.cloud.autoscaling.Cell;
import org.apache.solr.client.solrj.cloud.autoscaling.Clause;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaCount;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.Violation;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.StrUtils;

public class Suggestion {
    public static final String coreidxsize = "INDEX.sizeInBytes";
    static final Map<String, ConditionType> validatetypes = new HashMap<String, ConditionType>();
    public static final Map<String, String> tagVsPerReplicaVal = Stream.of(ConditionType.values()).filter(tag -> tag.perReplicaValue != null).collect(Collectors.toMap(tag -> tag.tagName, tag -> tag.perReplicaValue));

    public static ConditionType getTagType(String name) {
        ConditionType info = validatetypes.get(name);
        if (info == null && name.startsWith("sysprop.")) {
            info = ConditionType.LAZY;
        }
        if (info == null && name.startsWith("metrics:")) {
            info = ConditionType.LAZY;
        }
        return info;
    }

    private static void perNodeSuggestions(SuggestionCtx ctx) {
        if (ctx.violation == null) {
            return;
        }
        for (Violation.ReplicaInfoAndErr e : ctx.violation.getViolatingReplicas()) {
            Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).forceOperation(true).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(e.replicaInfo.getCollection(), e.replicaInfo.getShard())).hint(Suggester.Hint.SRC_NODE, e.replicaInfo.getNode());
            if (ctx.addSuggestion(suggester) != null) continue;
            break;
        }
    }

    static {
        for (ConditionType t : ConditionType.values()) {
            validatetypes.put(t.tagName, t);
        }
    }

    public static enum ConditionType {
        COLL("collection", String.class, null, null, null),
        SHARD("shard", String.class, null, null, null),
        REPLICA("replica", Long.class, null, 0L, null),
        PORT("port", Long.class, null, 1L, 65535L),
        IP_1("ip_1", Long.class, null, 0L, 255L),
        IP_2("ip_2", Long.class, null, 0L, 255L),
        IP_3("ip_3", Long.class, null, 0L, 255L),
        IP_4("ip_4", Long.class, null, 0L, 255L),
        FREEDISK("freedisk", (Class)Double.class, null, (Number)0.0, (Number)Double.MAX_VALUE, "INDEX.sizeInBytes", Boolean.TRUE){

            @Override
            public Object convertVal(Object val) {
                Number value = (Number)super.validate("freedisk", val, false);
                if (value != null) {
                    value = value.doubleValue() / 1024.0 / 1024.0 / 1024.0;
                }
                return value;
            }

            @Override
            public int compareViolation(Violation v1, Violation v2) {
                return Long.compare(v1.getViolatingReplicas().stream().mapToLong(v -> v.delta == null ? 0L : v.delta).max().orElse(0L), v2.getViolatingReplicas().stream().mapToLong(v3 -> v3.delta == null ? 0L : v3.delta).max().orElse(0L));
            }

            @Override
            public void getSuggestions(SuggestionCtx ctx) {
                if (ctx.violation == null) {
                    return;
                }
                if (ctx.violation.replicaCountDelta < 0L && !ctx.violation.getViolatingReplicas().isEmpty()) {
                    Comparator<Row> rowComparator = Comparator.comparing(r -> (Double)r.getVal("freedisk", 0.0));
                    List matchingNodes = ctx.session.matrix.stream().filter(row -> ctx.violation.getViolatingReplicas().stream().anyMatch(p -> row.node.equals(p.replicaInfo.getNode()))).sorted(rowComparator).collect(Collectors.toList());
                    block0: for (Row node : matchingNodes) {
                        ArrayList replicas = new ArrayList();
                        node.forEachReplica(replicas::add);
                        replicas.sort((r1, r2) -> {
                            Long s1 = Clause.parseLong(ConditionType.CORE_IDX.tagName, r1.getVariables().get(ConditionType.CORE_IDX.tagName));
                            Long s2 = Clause.parseLong(ConditionType.CORE_IDX.tagName, r2.getVariables().get(ConditionType.CORE_IDX.tagName));
                            if (s1 != null && s2 != null) {
                                return s1.compareTo(s2);
                            }
                            return 0;
                        });
                        long currentDelta = ctx.violation.getClause().tag.delta(node.getVal("freedisk"));
                        for (ReplicaInfo replica : replicas) {
                            if (currentDelta <= 0L) continue block0;
                            if (replica.getVariables().get(ConditionType.CORE_IDX.tagName) == null) continue;
                            Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.COLL_SHARD, new Pair<String, String>(replica.getCollection(), replica.getShard())).hint(Suggester.Hint.SRC_NODE, node.node).forceOperation(true);
                            if (ctx.addSuggestion(suggester) == null) continue block0;
                            currentDelta -= Clause.parseLong(ConditionType.CORE_IDX.tagName, replica.getVariable(ConditionType.CORE_IDX.tagName)).longValue();
                        }
                    }
                }
            }

            @Override
            public void projectAddReplica(Cell cell, ReplicaInfo ri) {
                for (Row row : cell.getRow().session.matrix) {
                    row.forEachReplica(replicaInfo -> {
                        if (ri != replicaInfo && ri.getCollection().equals(replicaInfo.getCollection()) && ri.getShard().equals(replicaInfo.getShard()) && ri.getVariable(1.CORE_IDX.tagName) == null && replicaInfo.getVariable(1.CORE_IDX.tagName) != null) {
                            ri.getVariables().put(1.CORE_IDX.tagName, this.validate(1.CORE_IDX.tagName, replicaInfo.getVariable(1.CORE_IDX.tagName), false));
                        }
                    });
                }
                Double idxSize = (Double)this.validate(1.CORE_IDX.tagName, ri.getVariable(1.CORE_IDX.tagName), false);
                if (idxSize == null) {
                    return;
                }
                Double currFreeDisk = cell.val == null ? 0.0 : (Double)cell.val;
                cell.val = currFreeDisk - idxSize;
            }

            @Override
            public void projectRemoveReplica(Cell cell, ReplicaInfo ri) {
                Double idxSize = (Double)this.validate(1.CORE_IDX.tagName, ri.getVariable(1.CORE_IDX.tagName), false);
                if (idxSize == null) {
                    return;
                }
                Double currFreeDisk = cell.val == null ? 0.0 : (Double)cell.val;
                cell.val = currFreeDisk + idxSize;
            }
        }
        ,
        CORE_IDX("INDEX.sizeInBytes", (Class)Double.class, null, (Number)0.0, (Number)Double.MAX_VALUE){

            @Override
            public Object convertVal(Object val) {
                return FREEDISK.convertVal(val);
            }
        }
        ,
        NODE_ROLE("nodeRole", String.class, Collections.singleton("overseer"), null, null),
        CORES("cores", (Class)Long.class, null, (Number)0L, (Number)Long.MAX_VALUE, null, Boolean.TRUE){

            @Override
            public void addViolatingReplicas(ViolationCtx ctx) {
                for (Row r : ctx.allRows) {
                    if (ctx.clause.tag.isPass(r)) continue;
                    r.forEachReplica(replicaInfo -> ctx.currentViolation.addReplica(new Violation.ReplicaInfoAndErr((ReplicaInfo)replicaInfo).withDelta(ctx.clause.tag.delta(r.getVal("cores")))));
                }
            }

            @Override
            public void getSuggestions(SuggestionCtx ctx) {
                if (ctx.violation == null || ctx.violation.replicaCountDelta == 0L) {
                    return;
                }
                if (ctx.violation.replicaCountDelta > 0L) {
                    int i = 0;
                    while ((long)i < Math.abs(ctx.violation.replicaCountDelta)) {
                        Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.SRC_NODE, ctx.violation.node);
                        ctx.addSuggestion(suggester);
                        ++i;
                    }
                }
            }

            @Override
            public void projectAddReplica(Cell cell, ReplicaInfo ri) {
                cell.val = cell.val == null ? 0L : ((Number)cell.val).longValue() + 1L;
            }

            @Override
            public void projectRemoveReplica(Cell cell, ReplicaInfo ri) {
                cell.val = cell.val == null ? 0L : ((Number)cell.val).longValue() - 1L;
            }
        }
        ,
        SYSLOADAVG("sysLoadAvg", Double.class, null, 0.0, 100.0, null, Boolean.TRUE),
        HEAPUSAGE("heapUsage", Double.class, null, 0.0, null, null, Boolean.TRUE),
        NUMBER("NUMBER", Long.class, null, 0L, Long.MAX_VALUE, null, Boolean.TRUE),
        STRING("STRING", String.class, null, null, null),
        NODE("node", (Class)String.class, null, null, null){

            @Override
            public void getSuggestions(SuggestionCtx ctx) {
                if (ctx.violation == null || ctx.violation.replicaCountDelta == 0L) {
                    return;
                }
                if (ctx.violation.replicaCountDelta > 0L) {
                    int i = 0;
                    while ((long)i < Math.abs(ctx.violation.replicaCountDelta)) {
                        Suggester suggester = ctx.session.getSuggester(CollectionParams.CollectionAction.MOVEREPLICA).hint(Suggester.Hint.SRC_NODE, ctx.violation.node).hint(ctx.violation.shard.equals("#ANY") ? Suggester.Hint.COLL : Suggester.Hint.COLL_SHARD, ctx.violation.shard.equals("#ANY") ? ctx.violation.coll : new Pair<String, String>(ctx.violation.coll, ctx.violation.shard));
                        ctx.addSuggestion(suggester);
                        ++i;
                    }
                }
            }
        }
        ,
        LAZY("LAZY", null, null, null, null){

            @Override
            public Object validate(String name, Object val, boolean isRuleVal) {
                return Clause.parseString(val);
            }

            @Override
            public void getSuggestions(SuggestionCtx ctx) {
                Suggestion.perNodeSuggestions(ctx);
            }
        }
        ,
        DISKTYPE("diskType", (Class)String.class, (Set)Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ssd", "rotational"))), null, null, null, null){

            @Override
            public void getSuggestions(SuggestionCtx ctx) {
                Suggestion.perNodeSuggestions(ctx);
            }
        };

        final Class type;
        final Set<String> vals;
        final Number min;
        final Number max;
        final Boolean additive;
        public final String tagName;
        public final String perReplicaValue;

        private ConditionType(String tagName, Class type, Set<String> vals, Number min, Number max) {
            this(tagName, type, vals, min, max, null, null);
        }

        private ConditionType(String tagName, Class type, Set<String> vals, Number min, Number max, String perReplicaValue, Boolean additive) {
            this.tagName = tagName;
            this.type = type;
            this.vals = vals;
            this.min = min;
            this.max = max;
            this.perReplicaValue = perReplicaValue;
            this.additive = additive;
        }

        public void getSuggestions(SuggestionCtx ctx) {
            Suggestion.perNodeSuggestions(ctx);
        }

        public void addViolatingReplicas(ViolationCtx ctx) {
            for (Row row : ctx.allRows) {
                row.forEachReplica(replica -> {
                    if (ctx.clause.replica.isPass(0) && !ctx.clause.tag.isPass(row)) {
                        return;
                    }
                    if (!ctx.clause.replica.isPass(0) && ctx.clause.tag.isPass(row)) {
                        return;
                    }
                    if (!ctx.currentViolation.matchShard(replica.getShard())) {
                        return;
                    }
                    if (!ctx.clause.collection.isPass(ctx.currentViolation.coll) || !ctx.clause.shard.isPass(ctx.currentViolation.shard)) {
                        return;
                    }
                    ctx.currentViolation.addReplica(new Violation.ReplicaInfoAndErr((ReplicaInfo)replica).withDelta(ctx.clause.tag.delta(row.getVal(ctx.clause.tag.name))));
                });
            }
        }

        public Object convertVal(Object val) {
            return val;
        }

        public Object validate(String name, Object val, boolean isRuleVal) {
            if (name == null) {
                name = this.tagName;
            }
            if (this.type == Double.class) {
                Double num = Clause.parseDouble(name, val);
                if (isRuleVal) {
                    if (this.min != null && Double.compare(num, (Double)this.min) == -1) {
                        throw new RuntimeException(name + ": " + val + " must be greater than " + this.min);
                    }
                    if (this.max != null && Double.compare(num, (Double)this.max) == 1) {
                        throw new RuntimeException(name + ": " + val + " must be less than " + this.max);
                    }
                }
                return num;
            }
            if (this.type == Long.class) {
                Long num = Clause.parseLong(name, val);
                if (isRuleVal) {
                    if (this.min != null && num < this.min.longValue()) {
                        throw new RuntimeException(name + ": " + val + " must be greater than " + this.min);
                    }
                    if (this.max != null && num > this.max.longValue()) {
                        throw new RuntimeException(name + ": " + val + " must be less than " + this.max);
                    }
                }
                return num;
            }
            if (this.type == String.class) {
                if (isRuleVal && this.vals != null && !this.vals.contains(val)) {
                    throw new RuntimeException(name + ": " + val + " must be one of " + StrUtils.join(this.vals, ','));
                }
                return val;
            }
            throw new RuntimeException("Invalid type ");
        }

        public void projectAddReplica(Cell cell, ReplicaInfo ri) {
        }

        public void projectRemoveReplica(Cell cell, ReplicaInfo ri) {
        }

        public int compareViolation(Violation v1, Violation v2) {
            if (v2.replicaCountDelta == null || v1.replicaCountDelta == null) {
                return 0;
            }
            if (Math.abs(v1.replicaCountDelta) == Math.abs(v2.replicaCountDelta)) {
                return 0;
            }
            return Math.abs(v1.replicaCountDelta) < Math.abs(v2.replicaCountDelta) ? -1 : 1;
        }
    }

    static class SuggestionCtx {
        public Policy.Session session;
        public Violation violation;
        private List<Suggester.SuggestionInfo> suggestions = new ArrayList<Suggester.SuggestionInfo>();

        SuggestionCtx() {
        }

        SolrRequest addSuggestion(Suggester suggester) {
            SolrRequest op = suggester.getSuggestion();
            if (op != null) {
                this.session = suggester.getSession();
                this.suggestions.add(new Suggester.SuggestionInfo(this.violation, ((V2RequestSupport)((Object)op.setUseV2(true))).getV2Request()));
            }
            return op;
        }

        public SuggestionCtx setViolation(Violation violation) {
            this.violation = violation;
            return this;
        }

        public List<Suggester.SuggestionInfo> getSuggestions() {
            return this.suggestions;
        }
    }

    static class ViolationCtx {
        String tagKey;
        Clause clause;
        ReplicaCount count;
        Violation currentViolation;
        List<Row> allRows;
        List<Violation> allViolations = new ArrayList<Violation>();

        public ViolationCtx(Clause clause, List<Row> allRows) {
            this.allRows = allRows;
            this.clause = clause;
        }

        public ViolationCtx reset(String tagKey, ReplicaCount count, Violation currentViolation) {
            this.tagKey = tagKey;
            this.count = count;
            this.currentViolation = currentViolation;
            this.allViolations.add(currentViolation);
            return this;
        }
    }
}

