/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class MapSerializer
extends SimpleTypeSerializer<Map> {
    public MapSerializer() {
        super(DataType.MAP);
    }

    @Override
    protected Map readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int length = buffer.readInt();
        LinkedHashMap result = new LinkedHashMap(length);
        for (int i = 0; i < length; ++i) {
            result.put(context.read(buffer), context.read(buffer));
        }
        return result;
    }

    @Override
    protected void writeValue(Map value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeInt(value.size());
        for (Map.Entry entry : value.entrySet()) {
            context.write(entry.getKey(), buffer);
            context.write(entry.getValue(), buffer);
        }
    }
}

