/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;

public class TreeSerializer
extends SimpleTypeSerializer<Tree> {
    public TreeSerializer() {
        super(DataType.TREE);
    }

    @Override
    protected Tree readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int length = buffer.readInt();
        Tree result = new Tree();
        for (int i = 0; i < length; ++i) {
            result.put(context.read(buffer), (Object)context.readValue(buffer, Tree.class, false));
        }
        return result;
    }

    @Override
    protected void writeValue(Tree value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeInt(value.size());
        for (Object key : value.keySet()) {
            context.write(key, buffer);
            context.writeValue(value.get(key), buffer, false);
        }
    }
}

