/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;

public class CompositeModelResolver
implements ModelResolver {
    private Contribution contribution;
    private Map<QName, Composite> map = new HashMap<QName, Composite>();

    public CompositeModelResolver(Contribution contribution, FactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
    }

    @Override
    public void addModel(Object resolved, ProcessorContext context) {
        Composite composite = (Composite)resolved;
        Composite old = this.map.put(composite.getName(), composite);
        if (old != null) {
            Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", "DuplicateCompositeName", composite.getName().toString(), this.contribution.getLocation());
        }
    }

    @Override
    public Object removeModel(Object resolved, ProcessorContext context) {
        return this.map.remove(((Composite)resolved).getName());
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        QName qname = ((Composite)unresolved).getName();
        Composite resolved = null;
        for (Import import_ : this.contribution.getImports()) {
            NamespaceImport namespaceImport;
            if (!(import_ instanceof NamespaceImport) || !(namespaceImport = (NamespaceImport)import_).getNamespace().equals(qname.getNamespaceURI()) || (resolved = namespaceImport.getModelResolver().resolveModel(Composite.class, (Composite)unresolved, context)).isUnresolved()) continue;
            return modelClass.cast(resolved);
        }
        resolved = this.map.get(qname);
        if (resolved != null) {
            return modelClass.cast(resolved);
        }
        return unresolved;
    }
}

