/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.local;

import java.util.logging.Logger;
import org.apache.tuscany.sca.core.invocation.AsyncResponseInvoker;
import org.apache.tuscany.sca.core.invocation.InterceptorAsyncImpl;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class LocalSCABindingInvocationInterceptor
extends InterceptorAsyncImpl {
    private static final Logger logger = Logger.getLogger(LocalSCABindingInvocationInterceptor.class.getName());
    private Invoker next;
    private boolean skipPrevious;

    @Override
    public Message invoke(Message msg) {
        return this.next.invoke(msg);
    }

    @Override
    public Invoker getNext() {
        return this.next;
    }

    @Override
    public void setNext(Invoker next) {
        this.next = next;
    }

    @Override
    public Message processRequest(Message msg) {
        return msg;
    }

    @Override
    public void invokeAsyncResponse(Message msg) {
        AsyncResponseInvoker respInvoker = (AsyncResponseInvoker)msg.getHeaders().get("ASYNC_RESPONSE_INVOKER");
        if (respInvoker != null && "SCA_LOCAL".equals(respInvoker.getBindingType())) {
            RuntimeEndpointReference responseEPR = (RuntimeEndpointReference)respInvoker.getResponseTargetAddress();
            msg.setFrom(responseEPR);
            String msgID = respInvoker.getRelatesToMsgID();
            msg.getHeaders().put("RELATES_TO", msgID);
            responseEPR.invokeAsyncResponse(msg);
            return;
        }
        InvokerAsyncResponse thePrevious = this.getPrevious();
        if (thePrevious != null) {
            thePrevious.invokeAsyncResponse(msg);
        }
    }

    @Override
    public Message processResponse(Message msg) {
        return msg;
    }
}

