/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.provider;

import org.apache.tuscany.sca.binding.sca.provider.DelegatingSCAReferenceBindingProvider;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.EndpointReferenceAsyncProvider;
import org.apache.tuscany.sca.provider.EndpointReferenceProvider;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.SCABindingMapper;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class RuntimeSCAReferenceBindingProvider
implements EndpointReferenceAsyncProvider {
    private RuntimeEndpointReference endpointReference;
    private boolean started = false;
    private ReferenceBindingProvider delegatingBindingProvider;
    private SCABindingMapper scaBindingMapper;

    public RuntimeSCAReferenceBindingProvider(ExtensionPointRegistry extensionPoints, RuntimeEndpointReference endpointReference) {
        this.endpointReference = endpointReference;
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.scaBindingMapper = utilities.getUtility(SCABindingMapper.class);
        this.getDelegatingProvider();
    }

    private ReferenceBindingProvider getDelegatingProvider() {
        if (this.delegatingBindingProvider == null) {
            this.delegatingBindingProvider = new DelegatingSCAReferenceBindingProvider(this.endpointReference, this.scaBindingMapper);
        }
        return this.delegatingBindingProvider;
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.delegatingBindingProvider.getBindingInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return this.delegatingBindingProvider.supportsOneWayInvocation();
    }

    @Override
    public Invoker createInvoker(Operation operation) {
        return this.delegatingBindingProvider.createInvoker(operation);
    }

    @Override
    public void start() {
        if (this.started) {
            return;
        }
        this.getDelegatingProvider().start();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        try {
            this.getDelegatingProvider().stop();
        }
        finally {
            this.started = false;
        }
    }

    @Override
    public void configure() {
        if (this.getDelegatingProvider() instanceof EndpointReferenceProvider) {
            ((EndpointReferenceProvider)this.getDelegatingProvider()).configure();
        }
    }

    @Override
    public boolean supportsNativeAsync() {
        return ((EndpointReferenceAsyncProvider)this.delegatingBindingProvider).supportsNativeAsync();
    }

    public RuntimeEndpointReference getDelegateEndpointReference() {
        return ((DelegatingSCAReferenceBindingProvider)this.delegatingBindingProvider).getDelegateEndpointReference();
    }
}

