/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.jaxws.ri;

import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.jaxws.ri.JAXWSReferenceBindingProvider;
import org.apache.tuscany.sca.binding.ws.jaxws.ri.JAXWSServiceBindingProvider;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.runtime.RuntimeProperties;

public class JAXWSBindingProviderFactory
implements BindingProviderFactory<WebServiceBinding> {
    private FactoryExtensionPoint modelFactories;
    private DataBindingExtensionPoint dataBindings;
    private String defaultPort = "8085";

    public JAXWSBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        this.modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.dataBindings = extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
        RuntimeProperties ps = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class).getUtility(RuntimeProperties.class);
        String pp = ps.getProperties().getProperty(this.getClass().getName() + ".defaultPort");
        if (pp != null) {
            this.defaultPort = ps.getProperties().getProperty(this.getClass().getName() + ".defaultPort");
        }
    }

    @Override
    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeEndpointReference endpointReference) {
        return new JAXWSReferenceBindingProvider(endpointReference, this.modelFactories, this.dataBindings);
    }

    @Override
    public ServiceBindingProvider createServiceBindingProvider(RuntimeEndpoint endpoint) {
        return new JAXWSServiceBindingProvider(endpoint, this.modelFactories, this.dataBindings, this.defaultPort);
    }

    @Override
    public Class<WebServiceBinding> getModelType() {
        return WebServiceBinding.class;
    }
}

