/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.wsdlgen;

import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tuscany.sca.binding.ws.wsdlgen.WSDLDefinitionGenerator;
import org.apache.tuscany.sca.binding.ws.wsdlgen.WSDLGenerationException;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.XMLTypeHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.util.ElementInfo;
import org.apache.tuscany.sca.interfacedef.util.JavaXMLMapper;
import org.apache.tuscany.sca.interfacedef.util.TypeInfo;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaGroupBase;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Interface2WSDLGenerator {
    private static final Logger logger = Logger.getLogger(Interface2WSDLGenerator.class.getName());
    private static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final String SCHEMA_NAME = "schema";
    private static final QName SCHEMA_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    private static final String ANYTYPE_NAME = "anyType";
    private static final QName ANYTYPE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "anyType");
    private WSDLFactory factory;
    private DataBindingExtensionPoint dataBindings;
    private WSDLDefinitionGenerator definitionGenerator;
    private DocumentBuilderFactory documentBuilderFactory;
    private boolean requiresSOAP12;
    private ModelResolver resolver;
    private XSDFactory xsdFactory;
    private Monitor monitor;

    public Interface2WSDLGenerator(boolean requiresSOAP12, ModelResolver resolver, DataBindingExtensionPoint dataBindings, XSDFactory xsdFactory, DocumentBuilderFactory documentBuilderFactory, Monitor monitor) throws WSDLException {
        this.requiresSOAP12 = requiresSOAP12;
        this.resolver = resolver;
        this.documentBuilderFactory = documentBuilderFactory;
        this.definitionGenerator = new WSDLDefinitionGenerator(requiresSOAP12);
        this.dataBindings = dataBindings;
        this.xsdFactory = xsdFactory;
        this.monitor = monitor;
        try {
            this.factory = AccessController.doPrivileged(new PrivilegedExceptionAction<WSDLFactory>(){

                @Override
                public WSDLFactory run() throws WSDLException {
                    WSDLFactory factory = WSDLFactory.newInstance();
                    return factory;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (WSDLException)e.getException();
        }
    }

    private static void logWarning(Problem problem) {
        Logger problemLogger = Logger.getLogger(problem.getSourceClassName(), problem.getResourceBundleName());
        if (problemLogger != null) {
            problemLogger.logp(Level.WARNING, problem.getSourceClassName(), (String)null, problem.getMessageId(), problem.getMessageParams());
        } else {
            logger.severe("Can't get logger " + problem.getSourceClassName() + " with bundle " + problem.getResourceBundleName());
        }
    }

    private void warning(String message, Interface interfaze, String ... messageParameters) {
        Problem problem = this.monitor.createProblem(this.getClass().getName(), "wsdlgen-validation-messages", Problem.Severity.WARNING, (Object)interfaze, message, messageParameters);
        if (this.monitor != null) {
            this.monitor.problem(problem);
        } else {
            Interface2WSDLGenerator.logWarning(problem);
        }
    }

    private void fatal(String message, Interface interfaze, String ... messageParameters) {
        Problem problem = this.monitor.createProblem(this.getClass().getName(), "wsdlgen-validation-messages", Problem.Severity.ERROR, (Object)interfaze, message, messageParameters);
        throw new WSDLGenerationException(problem.toString(), null, problem);
    }

    private XMLTypeHelper getTypeHelper(DataType type, Map<String, XMLTypeHelper> helpers) {
        if (type == null) {
            return null;
        }
        String db = type.getDataBinding();
        if (db == null) {
            return null;
        }
        while ("java:array".equals(db)) {
            type = (DataType)type.getLogical();
            db = type.getDataBinding();
        }
        return helpers.get(db);
    }

    private boolean inputTypesCompatible(DataType wrapperType, DataType<List<DataType>> inputType, Map<String, XMLTypeHelper> helpers) {
        XMLTypeHelper wrapperHelper = this.getTypeHelper(wrapperType, helpers);
        for (DataType dt : inputType.getLogical()) {
            if (this.getTypeHelper(dt, helpers) == wrapperHelper) continue;
            return false;
        }
        return true;
    }

    private boolean outputTypeCompatible(DataType wrapperType, DataType outputType, Map<String, XMLTypeHelper> helpers) {
        return this.inputTypesCompatible(wrapperType, outputType, helpers);
    }

    private void addDataType(Map<XMLTypeHelper, List<DataType>> map, DataType type, Map<String, XMLTypeHelper> helpers) {
        XMLTypeHelper helper;
        List<DataType> types;
        if (type == null) {
            return;
        }
        String db = type.getDataBinding();
        if (db == null) {
            return;
        }
        if ("java:array".equals(db)) {
            DataType dt = (DataType)type.getLogical();
            db = dt.getDataBinding();
        }
        if ((types = map.get(helper = helpers.get(db))) == null) {
            types = new ArrayList<DataType>();
            map.put(helper, types);
        }
        types.add(type);
    }

    /*
     * WARNING - void declaration
     */
    private Map<XMLTypeHelper, List<DataType>> getDataTypes(Interface intf, boolean useWrapper, Map<String, XMLTypeHelper> helpers) {
        HashMap<XMLTypeHelper, List<DataType>> dataTypes = new HashMap<XMLTypeHelper, List<DataType>>();
        for (Operation op : intf.getOperations()) {
            WrapperInfo inputWrapper = op.getInputWrapper();
            DataType<XMLType> dt1 = null;
            boolean useInputWrapper = useWrapper & inputWrapper != null;
            if (useInputWrapper) {
                dt1 = inputWrapper.getWrapperType();
                useInputWrapper &= this.inputTypesCompatible(dt1, op.getInputType(), helpers);
            }
            if (useInputWrapper) {
                this.addDataType(dataTypes, dt1, helpers);
            } else {
                for (DataType dataType : op.getInputType().getLogical()) {
                    this.addDataType(dataTypes, dataType, helpers);
                }
            }
            WrapperInfo outputWrapper = op.getOutputWrapper();
            Object var11_17 = null;
            boolean useOutputWrapper = useWrapper & outputWrapper != null;
            if (useOutputWrapper) {
                DataType<XMLType> dataType = outputWrapper.getWrapperType();
                useOutputWrapper &= this.outputTypeCompatible(dataType, op.getOutputType(), helpers);
            }
            if (useOutputWrapper) {
                void var11_19;
                this.addDataType(dataTypes, (DataType)var11_19, helpers);
            } else {
                void var11_14;
                if (op.getOutputType().getLogical().size() != 0) {
                    DataType dataType = op.getOutputType().getLogical().get(0);
                }
                this.addDataType(dataTypes, (DataType)var11_14, helpers);
            }
            for (DataType dt3 : op.getFaultTypes()) {
                DataType dt4 = (DataType)dt3.getLogical();
                this.addDataType(dataTypes, dt4, helpers);
            }
        }
        if (intf instanceof JavaInterface) {
            JavaInterface javaInterface = (JavaInterface)intf;
            Class<?>[] seeAlso = Interface2WSDLGenerator.getSeeAlso(javaInterface.getJavaClass());
            if (seeAlso != null) {
                for (Class<?> cls : seeAlso) {
                    DataTypeImpl<XMLType> dataTypeImpl = new DataTypeImpl<XMLType>(JAXBDataBinding.NAME, cls, XMLType.UNKNOWN);
                    this.addDataType(dataTypes, dataTypeImpl, helpers);
                }
            }
            if ((seeAlso = Interface2WSDLGenerator.getSeeAlso(javaInterface.getCallbackClass())) != null) {
                for (Class<?> cls : seeAlso) {
                    DataTypeImpl<XMLType> dataTypeImpl = new DataTypeImpl<XMLType>(JAXBDataBinding.NAME, cls, XMLType.UNKNOWN);
                    this.addDataType(dataTypes, dataTypeImpl, helpers);
                }
            }
        }
        return dataTypes;
    }

    private static Class<?>[] getSeeAlso(Class<?> interfaze) {
        if (interfaze == null) {
            return null;
        }
        XmlSeeAlso seeAlso = interfaze.getAnnotation(XmlSeeAlso.class);
        if (seeAlso == null) {
            return null;
        }
        return seeAlso.value();
    }

    public Definition generate(Interface interfaze, WSDLDefinition wsdlDefinition) throws WSDLException {
        if (interfaze == null) {
            return null;
        }
        if (interfaze instanceof WSDLInterface) {
            return ((WSDLInterface)interfaze).getWsdlDefinition().getDefinition();
        }
        JavaInterface iface = (JavaInterface)interfaze;
        if (!interfaze.isRemotable()) {
            this.fatal("InterfaceNotRemotable", interfaze, iface.getName());
        }
        QName name = this.getQName(iface);
        Definition definition = this.factory.newDefinition();
        if (this.requiresSOAP12) {
            definition.addNamespace("SOAP12", "http://schemas.xmlsoap.org/wsdl/soap12/");
        } else {
            definition.addNamespace("SOAP", "http://schemas.xmlsoap.org/wsdl/soap/");
        }
        definition.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        definition.addNamespace("xs", SCHEMA_NS);
        String namespaceURI = name.getNamespaceURI();
        definition.setTargetNamespace(namespaceURI);
        definition.setQName(new QName(namespaceURI, name.getLocalPart() + "Service", name.getPrefix()));
        definition.addNamespace(name.getPrefix(), namespaceURI);
        PortType portType = definition.createPortType();
        portType.setQName(name);
        Binding binding = this.definitionGenerator.createBinding(definition, portType);
        HashMap<String, XMLTypeHelper> helpers = new HashMap<String, XMLTypeHelper>();
        HashMap<QName, List<ElementInfo>> wrappers = new HashMap<QName, List<ElementInfo>>();
        for (Operation op : interfaze.getOperations()) {
            javax.wsdl.Operation operation = this.generateOperation(definition, op, helpers, wrappers);
            portType.addOperation(operation);
            String action = ((JavaOperation)op).getAction();
            if (action == null) {
                action = "";
            }
            BindingOperation bindingOp = this.definitionGenerator.createBindingOperation(definition, operation, action);
            binding.addBindingOperation(bindingOp);
        }
        portType.setUndefined(false);
        definition.addPortType(portType);
        binding.setUndefined(false);
        definition.addBinding(binding);
        wsdlDefinition.setBinding(binding);
        XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
        Map<XMLTypeHelper, List<DataType>> dataTypes = this.getDataTypes(interfaze, true, helpers);
        for (Map.Entry<XMLTypeHelper, List<DataType>> en : dataTypes.entrySet()) {
            XMLTypeHelper helper = en.getKey();
            if (helper == null) continue;
            List<XSDefinition> xsDefinitions = helper.getSchemaDefinitions(this.xsdFactory, this.resolver, en.getValue());
            this.mergeNoNamespaceSchema(namespaceURI, xsDefinitions);
            for (XSDefinition xsDef : xsDefinitions) {
                Interface2WSDLGenerator.loadXSD(schemaCollection, xsDef);
                wsdlDefinition.getXmlSchemas().add(xsDef);
            }
        }
        for (QName wrapperName : new HashSet(wrappers.keySet())) {
            if (wsdlDefinition.getXmlSchemaElement(wrapperName) == null) continue;
            wrappers.remove(wrapperName);
        }
        boolean reloadSchema = false;
        if (wrappers.size() > 0) {
            int i = 0;
            int index = 0;
            HashMap<String, XSDefinition> wrapperXSDs = new HashMap<String, XSDefinition>();
            HashMap prefixMaps = new HashMap();
            for (Map.Entry entry : wrappers.entrySet()) {
                String targetNS = ((QName)entry.getKey()).getNamespaceURI();
                Document schemaDoc = null;
                Element schema = null;
                XSDefinition xsDef = (XSDefinition)wrapperXSDs.get(targetNS);
                if (xsDef != null) {
                    schemaDoc = xsDef.getDocument();
                    schema = schemaDoc.getDocumentElement();
                } else {
                    xsDef = wsdlDefinition.getSchema(targetNS);
                    if (xsDef != null) {
                        schemaDoc = xsDef.getDocument();
                        schema = schemaDoc.getDocumentElement();
                        HashMap<String, String> prefixMap = (HashMap<String, String>)prefixMaps.get(schema);
                        if (prefixMap == null) {
                            prefixMap = new HashMap<String, String>();
                            prefixMaps.put(schema, prefixMap);
                            String[] prefixes = xsDef.getSchema().getNamespaceContext().getDeclaredPrefixes();
                            for (int j = 0; j < prefixes.length; ++j) {
                                prefixMap.put(xsDef.getSchema().getNamespaceContext().getNamespaceURI(prefixes[j]), prefixes[j]);
                            }
                        }
                        reloadSchema = true;
                    } else {
                        schemaDoc = this.createDocument();
                        schema = schemaDoc.createElementNS(SCHEMA_NS, "xs:schema");
                        schema.setAttribute("elementFormDefault", "unqualified");
                        schema.setAttribute("attributeFormDefault", "qualified");
                        schema.setAttribute("targetNamespace", targetNS);
                        schema.setAttributeNS(XMLNS_NS, "xmlns:xs", SCHEMA_NS);
                        schemaDoc.appendChild(schema);
                        prefixMaps.put(schema, new HashMap());
                        xsDef = this.xsdFactory.createXSDefinition();
                        xsDef.setUnresolved(true);
                        xsDef.setNamespace(targetNS);
                        xsDef.setDocument(schemaDoc);
                        xsDef.setLocation(URI.create("xsd_" + index + ".xsd"));
                        ++index;
                        wrapperXSDs.put(targetNS, xsDef);
                        wsdlDefinition.getXmlSchemas().add(xsDef);
                    }
                }
                Element wrapper = schemaDoc.createElementNS(SCHEMA_NS, "xs:element");
                schema.appendChild(wrapper);
                wrapper.setAttribute("name", ((QName)entry.getKey()).getLocalPart());
                if (((List)entry.getValue()).size() == 1 && ((ElementInfo)((List)entry.getValue()).get(0)).getQName() == null) {
                    QName typeName = ((ElementInfo)((List)entry.getValue()).get(0)).getType().getQName();
                    String nsURI = typeName.getNamespaceURI();
                    if ("".equals(nsURI)) {
                        wrapper.setAttribute("type", typeName.getLocalPart());
                        Interface2WSDLGenerator.addSchemaImport(schema, "", schemaDoc);
                        continue;
                    }
                    if (targetNS.equals(nsURI)) {
                        wrapper.setAttribute("type", typeName.getLocalPart());
                        continue;
                    }
                    if (SCHEMA_NS.equals(nsURI)) {
                        wrapper.setAttribute("type", "xs:" + typeName.getLocalPart());
                        continue;
                    }
                    Map prefixMap = (Map)prefixMaps.get(schema);
                    String prefix = (String)prefixMap.get(nsURI);
                    if (prefix == null) {
                        prefix = "ns" + i++;
                        prefixMap.put(nsURI, prefix);
                        schema.setAttributeNS(XMLNS_NS, "xmlns:" + prefix, nsURI);
                        Interface2WSDLGenerator.addSchemaImport(schema, nsURI, schemaDoc);
                    }
                    wrapper.setAttribute("type", prefix + ":" + typeName.getLocalPart());
                    continue;
                }
                Element complexType = schemaDoc.createElementNS(SCHEMA_NS, "xs:complexType");
                wrapper.appendChild(complexType);
                if (((List)entry.getValue()).size() <= 0) continue;
                Element sequence = schemaDoc.createElementNS(SCHEMA_NS, "xs:sequence");
                complexType.appendChild(sequence);
                for (ElementInfo element : (List)entry.getValue()) {
                    QName typeName;
                    String nsURI;
                    Element xsElement = schemaDoc.createElementNS(SCHEMA_NS, "xs:element");
                    if (element.isMany()) {
                        xsElement.setAttribute("maxOccurs", "unbounded");
                    }
                    xsElement.setAttribute("minOccurs", "0");
                    xsElement.setAttribute("name", element.getQName().getLocalPart());
                    if (element.isNillable()) {
                        xsElement.setAttribute("nillable", "true");
                    }
                    if ("".equals(nsURI = (typeName = element.getType().getQName()).getNamespaceURI())) {
                        xsElement.setAttribute("type", typeName.getLocalPart());
                        Interface2WSDLGenerator.addSchemaImport(schema, "", schemaDoc);
                    } else if (SCHEMA_NS.equals(nsURI)) {
                        xsElement.setAttribute("type", "xs:" + typeName.getLocalPart());
                    } else {
                        Map prefixMap = (Map)prefixMaps.get(schema);
                        String prefix = (String)prefixMap.get(nsURI);
                        if (prefix == null) {
                            if (targetNS.equals(nsURI)) {
                                prefix = "tns";
                            } else {
                                prefix = "ns" + i++;
                                Interface2WSDLGenerator.addSchemaImport(schema, nsURI, schemaDoc);
                            }
                            prefixMap.put(nsURI, prefix);
                            schema.setAttributeNS(XMLNS_NS, "xmlns:" + prefix, nsURI);
                        }
                        xsElement.setAttribute("type", prefix + ":" + typeName.getLocalPart());
                    }
                    sequence.appendChild(xsElement);
                }
            }
        }
        if (reloadSchema) {
            schemaCollection = new XmlSchemaCollection();
            for (XSDefinition xsDef : wsdlDefinition.getXmlSchemas()) {
                xsDef.setSchema(null);
                xsDef.setSchemaCollection(null);
            }
        }
        for (XSDefinition xsDef : wsdlDefinition.getXmlSchemas()) {
            this.addSchemaExtension(xsDef, schemaCollection, wsdlDefinition, definition);
        }
        return definition;
    }

    private void mergeNoNamespaceSchema(String toNamespace, List<XSDefinition> xsDefinitions) {
        String fromNamespace = "";
        Document fromDoc = null;
        XSDefinition fromXsDef = null;
        Document toDoc = null;
        ArrayList<Document> relatedDocs = new ArrayList<Document>();
        for (XSDefinition xsDef : xsDefinitions) {
            if (xsDef.getNamespace().equals("")) {
                fromXsDef = xsDef;
                fromDoc = xsDef.getDocument();
                continue;
            }
            if (xsDef.getNamespace().equals(toNamespace)) {
                toDoc = xsDef.getDocument();
                continue;
            }
            relatedDocs.add(xsDef.getDocument());
        }
        if (fromDoc != null && toDoc != null) {
            try {
                List<XmlSchema> resultingDocs = this.mergeSchema(fromNamespace, fromDoc, toNamespace, toDoc, relatedDocs);
                for (XmlSchema schema : resultingDocs) {
                    for (XSDefinition xsDef : xsDefinitions) {
                        if (!xsDef.getNamespace().equals(schema.getTargetNamespace())) continue;
                        Document doc = schema.getSchemaDocument();
                        xsDef.setDocument(doc);
                    }
                }
                xsDefinitions.remove(fromXsDef);
            }
            catch (XmlSchemaSerializer.XmlSchemaSerializerException ex) {
                throw new WSDLGenerationException(ex);
            }
        }
    }

    private List<XmlSchema> mergeSchema(String fromNamespace, Document fromDoc, String toNamespace, Document toDoc, List<Document> relatedDocs) throws XmlSchemaSerializer.XmlSchemaSerializerException {
        XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
        schemaCollection.read(fromDoc.getDocumentElement());
        schemaCollection.read(toDoc.getDocumentElement());
        for (Document doc : relatedDocs) {
            schemaCollection.read(doc.getDocumentElement());
        }
        XmlSchema fromSchema = null;
        XmlSchema toSchema = null;
        ArrayList<XmlSchema> resultSchema = new ArrayList<XmlSchema>();
        XmlSchema[] schemas = schemaCollection.getXmlSchemas();
        for (int i = 0; i < schemas.length; ++i) {
            XmlSchema schema = schemas[i];
            if (schema.getTargetNamespace() == null) {
                fromSchema = schema;
                continue;
            }
            if (schema.getTargetNamespace().equals(toNamespace)) {
                toSchema = schema;
                resultSchema.add(schema);
                continue;
            }
            if (schema.getTargetNamespace().equals(SCHEMA_NS)) continue;
            resultSchema.add(schema);
        }
        if (fromSchema == null || toSchema == null) {
            return resultSchema;
        }
        XmlSchemaObjectCollection fromItems = fromSchema.getItems();
        XmlSchemaObjectCollection toItems = toSchema.getItems();
        ArrayList<XmlSchemaObject> movedItems = new ArrayList<XmlSchemaObject>();
        Iterator iter = fromItems.getIterator();
        while (iter.hasNext()) {
            XmlSchemaObject obj = (XmlSchemaObject)iter.next();
            if (obj instanceof XmlSchemaImport && ((XmlSchemaImport)obj).getNamespace().equals(toNamespace)) continue;
            toItems.add(obj);
            movedItems.add(obj);
        }
        for (XmlSchemaObject obj : movedItems) {
            this.fixUpMovedTypeReferences(fromNamespace, toNamespace, obj, resultSchema);
        }
        return resultSchema;
    }

    public void fixUpMovedTypeReferences(String fromNamespace, String toNamespace, XmlSchemaObject fixUpObj, List<XmlSchema> relatedSchema) {
        if (!(fixUpObj instanceof XmlSchemaComplexType)) {
            return;
        }
        for (XmlSchema schema : relatedSchema) {
            int importRemoveIndex = -1;
            for (int i = 0; i < schema.getItems().getCount(); ++i) {
                XmlSchemaObject obj = schema.getItems().getItem(i);
                this.processXMLSchemaObject(toNamespace, obj, fixUpObj);
                if (!(obj instanceof XmlSchemaImport) || !((XmlSchemaImport)obj).getNamespace().equals(fromNamespace)) continue;
                importRemoveIndex = i;
            }
            if (importRemoveIndex < 0) continue;
            schema.getItems().removeAt(importRemoveIndex);
        }
    }

    public void processXMLSchemaObject(String toNamespace, XmlSchemaObject obj, XmlSchemaObject fixUpObj) {
        if (obj instanceof XmlSchemaComplexType) {
            this.processXMLSchemaObject(toNamespace, ((XmlSchemaComplexType)obj).getParticle(), fixUpObj);
            this.processXMLSchemaObject(toNamespace, ((XmlSchemaComplexType)obj).getContentModel(), fixUpObj);
        } else if (obj instanceof XmlSchemaComplexContent) {
            this.processXMLSchemaObject(toNamespace, ((XmlSchemaComplexContent)obj).getContent(), fixUpObj);
        } else if (obj instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)obj;
            if (element.getSchemaType() == fixUpObj) {
                QName name = element.getSchemaTypeName();
                QName newName = new QName(toNamespace, name.getLocalPart());
                element.setSchemaTypeName(newName);
            }
            ((XmlSchemaElement)obj).getSchemaType();
        } else if (obj instanceof XmlSchemaGroupBase) {
            XmlSchemaObjectCollection items = ((XmlSchemaGroupBase)obj).getItems();
            Iterator iter = items.getIterator();
            while (iter.hasNext()) {
                this.processXMLSchemaObject(toNamespace, (XmlSchemaObject)iter.next(), fixUpObj);
            }
        } else if (obj instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension extension = (XmlSchemaComplexContentExtension)obj;
            QName name = extension.getBaseTypeName();
            QName newName = new QName(toNamespace, name.getLocalPart());
            extension.setBaseTypeName(newName);
        }
    }

    private void printDOM(Document document) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(System.out);
            transformer.transform(source, result);
            System.out.println("\n");
            System.out.flush();
        }
        catch (Exception ex) {
            ex.toString();
        }
    }

    private static void addSchemaImport(Element schema, String nsURI, Document schemaDoc) {
        Element imp = schemaDoc.createElementNS(SCHEMA_NS, "xs:import");
        if (!"".equals(nsURI)) {
            imp.setAttribute("namespace", nsURI);
        }
        NodeList childNodes = schema.getElementsByTagNameNS(SCHEMA_NS, "import");
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String ns;
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element) || !nsURI.equals(ns = ((Element)childNode).getAttributeNS(SCHEMA_NS, "namespace"))) continue;
            return;
        }
        Node firstNodeAfterImport = null;
        firstNodeAfterImport = childNodes.getLength() > 0 ? childNodes.item(childNodes.getLength() - 1).getNextSibling() : schema.getFirstChild();
        if (firstNodeAfterImport == null) {
            schema.appendChild(imp);
        } else {
            schema.insertBefore(imp, firstNodeAfterImport);
        }
    }

    private void addSchemaExtension(XSDefinition xsDef, XmlSchemaCollection schemaCollection, WSDLDefinition wsdlDefinition, Definition definition) throws WSDLException {
        if (xsDef.getAggregatedDefinitions() != null) {
            for (XSDefinition xsd : xsDef.getAggregatedDefinitions()) {
                this.addSchemaExtension(xsd, schemaCollection, wsdlDefinition, definition);
            }
        } else {
            String nsURI = xsDef.getNamespace();
            Document document = xsDef.getDocument();
            if (document == null) {
                try {
                    NamespaceMap prefixMap = new NamespaceMap();
                    prefixMap.add("xs", SCHEMA_NS);
                    prefixMap.add("tns", nsURI);
                    XmlSchema schemaDef = xsDef.getSchema();
                    schemaDef.setNamespaceContext(prefixMap);
                    Document[] docs = schemaDef.getAllSchemas();
                    document = docs[docs.length - 1];
                    document.setDocumentURI(xsDef.getLocation().toString());
                    xsDef.setDocument(document);
                }
                catch (XmlSchemaException e) {
                    throw new RuntimeException(e);
                }
            }
            Interface2WSDLGenerator.loadXSD(schemaCollection, xsDef);
            Element schema = document.getDocumentElement();
            Schema schemaExt = this.createSchemaExt(definition);
            schemaExt.setDocumentBaseURI(document.getDocumentURI());
            schemaExt.setElement(schema);
        }
    }

    private static void loadXSD(XmlSchemaCollection schemaCollection, XSDefinition definition) {
        if (definition.getSchema() != null) {
            return;
        }
        if (definition.getDocument() != null) {
            String uri = null;
            if (definition.getLocation() != null) {
                uri = definition.getLocation().toString();
            }
            XmlSchema schema = schemaCollection.read(definition.getDocument(), uri, null);
            if (definition.getSchemaCollection() == null) {
                definition.setSchemaCollection(schemaCollection);
            }
            if (definition.getSchema() == null) {
                definition.setSchema(schema);
            }
        }
    }

    public Schema createSchemaExt(Definition definition) throws WSDLException {
        Types types = definition.getTypes();
        if (types == null) {
            types = definition.createTypes();
            definition.setTypes(types);
        }
        Schema schemaExt = this.createSchema(definition);
        types.addExtensibilityElement(schemaExt);
        return schemaExt;
    }

    public Schema createSchema(Definition definition) throws WSDLException {
        return (Schema)definition.getExtensionRegistry().createExtension(Types.class, SCHEMA_QNAME);
    }

    public Document createDocument() {
        Document document;
        try {
            if (this.documentBuilderFactory == null) {
                this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.documentBuilderFactory.setNamespaceAware(true);
            }
            document = this.documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            throw new WSDLGenerationException(ex);
        }
        return document;
    }

    protected QName getQName(Interface interfaze) {
        JavaInterface iface = (JavaInterface)interfaze;
        QName qname = iface.getQName();
        if (qname != null) {
            return qname;
        }
        Class<?> javaClass = iface.getJavaClass();
        return new QName(JavaXMLMapper.getNamespace(javaClass), javaClass.getSimpleName(), "tns");
    }

    public javax.wsdl.Operation generateOperation(Definition definition, Operation op, Map<String, XMLTypeHelper> helpers, Map<QName, List<ElementInfo>> wrappers) throws WSDLException {
        javax.wsdl.Operation operation = definition.createOperation();
        operation.setName(op.getName());
        operation.setUndefined(false);
        Input input = definition.createInput();
        Message inputMsg = definition.createMessage();
        String namespaceURI = definition.getQName().getNamespaceURI();
        QName inputMsgName = new QName(namespaceURI, op.getName());
        inputMsg.setQName(inputMsgName);
        inputMsg.setUndefined(false);
        definition.addMessage(inputMsg);
        ArrayList<ElementInfo> elements = null;
        if (op.getInputWrapper() != null) {
            inputMsg.addPart(this.generateWrapperPart(definition, op, helpers, wrappers, true));
        } else {
            int i = 0;
            for (DataType d : op.getInputType().getLogical()) {
                inputMsg.addPart(this.generatePart(definition, d, "arg" + i));
                elements = new ArrayList<ElementInfo>();
                ElementInfo element = this.getElementInfo(d.getPhysical(), d, null, helpers);
                elements.add(element);
                QName elementName = ((XMLType)d.getLogical()).getElementName();
                wrappers.put(elementName, elements);
                ++i;
            }
        }
        input.setMessage(inputMsg);
        operation.setInput(input);
        if (!op.isNonBlocking()) {
            Output output = definition.createOutput();
            Message outputMsg = definition.createMessage();
            QName outputMsgName = new QName(namespaceURI, op.getName() + "Response");
            outputMsg.setQName(outputMsgName);
            outputMsg.setUndefined(false);
            definition.addMessage(outputMsg);
            if (op.getOutputWrapper() != null) {
                outputMsg.addPart(this.generateWrapperPart(definition, op, helpers, wrappers, false));
            } else if (op.getOutputType() != null && op.getOutputType().getLogical().size() != 0) {
                DataType outputType = op.getOutputType().getLogical().get(0);
                outputMsg.addPart(this.generatePart(definition, outputType, "return"));
                elements = new ArrayList();
                ElementInfo element = this.getElementInfo(outputType.getPhysical(), outputType, null, helpers);
                elements.add(element);
                QName elementName = ((XMLType)outputType.getLogical()).getElementName();
                wrappers.put(elementName, elements);
            }
            output.setMessage(outputMsg);
            operation.setOutput(output);
            operation.setStyle(OperationType.REQUEST_RESPONSE);
        } else {
            operation.setStyle(OperationType.ONE_WAY);
        }
        for (DataType faultType : op.getFaultTypes()) {
            Fault fault = definition.createFault();
            QName faultName = ((XMLType)((DataType)faultType.getLogical()).getLogical()).getElementName();
            QName faultMsgName = new QName(namespaceURI, faultName.getLocalPart());
            fault.setName(faultName.getLocalPart());
            Message faultMsg = definition.getMessage(faultMsgName);
            if (faultMsg == null) {
                faultMsg = definition.createMessage();
                faultMsg.setQName(faultMsgName);
                faultMsg.setUndefined(false);
                definition.addMessage(faultMsg);
                faultMsg.addPart(this.generatePart(definition, (DataType)faultType.getLogical(), faultName.getLocalPart()));
            }
            fault.setMessage(faultMsg);
            operation.addFault(fault);
            if (((DataType)faultType.getLogical()).getPhysical() != faultType.getPhysical()) {
                DataType logical = (DataType)faultType.getLogical();
                elements = new ArrayList();
                elements.add(this.getElementInfo(logical.getPhysical(), logical, null, helpers));
            } else {
                for (DataType<XMLType> propDT : op.getFaultBeans().get(faultName)) {
                    XMLType logical = propDT.getLogical();
                    elements = new ArrayList();
                    elements.add(this.getElementInfo(propDT.getPhysical(), propDT, logical.getElementName(), helpers));
                }
            }
            wrappers.put(faultName, elements);
        }
        operation.setUndefined(false);
        return operation;
    }

    public Part generatePart(Definition definition, DataType arg, String partName) {
        Part part = definition.createPart();
        part.setName(partName);
        if (arg != null && arg.getLogical() instanceof XMLType) {
            XMLType xmlType = (XMLType)arg.getLogical();
            QName elementName = xmlType.getElementName();
            part.setElementName(elementName);
            Interface2WSDLGenerator.addNamespace(definition, elementName);
            if (xmlType.getElementName() == null) {
                QName typeName = xmlType.getTypeName();
                part.setTypeName(typeName);
                Interface2WSDLGenerator.addNamespace(definition, typeName);
            }
        }
        return part;
    }

    public Part generateWrapperPart(Definition definition, Operation operation, Map<String, XMLTypeHelper> helpers, Map<QName, List<ElementInfo>> wrappers, boolean input) throws WSDLException {
        Part part;
        block4: {
            part = definition.createPart();
            String partName = input ? operation.getName() : operation.getName() + "Response";
            part.setName(partName);
            WrapperInfo inputWrapper = operation.getInputWrapper();
            WrapperInfo outputWrapper = operation.getOutputWrapper();
            if (inputWrapper == null || outputWrapper == null) break block4;
            ElementInfo elementInfo = input ? inputWrapper.getWrapperElement() : outputWrapper.getWrapperElement();
            List<ElementInfo> elements = input ? inputWrapper.getChildElements() : outputWrapper.getChildElements();
            QName wrapperName = elementInfo.getQName();
            part.setElementName(wrapperName);
            Interface2WSDLGenerator.addNamespace(definition, wrapperName);
            wrappers.put(wrapperName, elements);
            Method method = ((JavaOperation)operation).getJavaMethod();
            if (input) {
                List<DataType> inputDTs = operation.getInputType().getLogical();
                for (int i = 0; i < inputDTs.size(); ++i) {
                    DataType nextInput = inputDTs.get(i);
                    elements.set(i, this.getElementInfo(nextInput.getPhysical(), nextInput, elements.get(i).getQName(), helpers));
                }
            } else {
                List<DataType> outputDTs = operation.getOutputType().getLogical();
                for (int i = 0; i < outputDTs.size(); ++i) {
                    DataType nextOutput = outputDTs.get(i);
                    elements.set(i, this.getElementInfo(nextOutput.getPhysical(), nextOutput, elements.get(i).getQName(), helpers));
                }
            }
        }
        return part;
    }

    private ElementInfo getElementInfo(Class javaType, DataType dataType, QName name, Map<String, XMLTypeHelper> helpers) {
        String db = dataType.getDataBinding();
        while ("java:array".equals(db)) {
            dataType = (DataType)dataType.getLogical();
            db = dataType.getDataBinding();
        }
        XMLTypeHelper helper = helpers.get(db);
        if (helper == null) {
            DataBinding dataBinding = this.dataBindings.getDataBinding(db);
            if (dataBinding == null) {
                XMLType xmlType;
                QName element = name;
                if ((element == null || dataType.getLogical() instanceof XMLType) && (xmlType = (XMLType)dataType.getLogical()).getElementName() != null) {
                    element = xmlType.getElementName();
                }
                return new ElementInfo(element, new TypeInfo(ANYTYPE_QNAME, false, null));
            }
            helper = dataBinding.getXMLTypeHelper();
            if (helper == null && (helper = helpers.get(JAXBDataBinding.NAME)) == null) {
                helper = this.dataBindings.getDataBinding(JAXBDataBinding.NAME).getXMLTypeHelper();
                helpers.put(JAXBDataBinding.NAME, helper);
            }
            helpers.put(db, helper);
        }
        TypeInfo typeInfo = null;
        ElementInfo element = null;
        if (byte[].class == javaType) {
            typeInfo = helper.getTypeInfo(javaType, dataType.getLogical());
            element = new ElementInfo(name, typeInfo);
            element.setMany(false);
        } else {
            typeInfo = helper.getTypeInfo(javaType.isArray() ? javaType.getComponentType() : javaType, dataType.getLogical());
            element = new ElementInfo(name, typeInfo);
            element.setMany(javaType.isArray());
        }
        Object logical = dataType.getLogical();
        if (logical instanceof XMLType && ((XMLType)logical).isMany()) {
            element.setMany(true);
        }
        element.setNillable(!javaType.isPrimitive());
        return element;
    }

    private static void addNamespace(Definition definition, QName name) {
        String namespace = name.getNamespaceURI();
        if (definition.getPrefix(namespace) == null) {
            definition.addNamespace("ns" + definition.getNamespaces().size(), namespace);
        }
    }

    public WSDLFactory getFactory() {
        return this.factory;
    }

    public void setFactory(WSDLFactory factory) {
        this.factory = factory;
    }
}

