/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.java.JavaImport;
import org.apache.tuscany.sca.contribution.java.impl.ContributionHelper;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.DefaultDelegatingModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;

public class ClassLoaderModelResolver
extends URLClassLoader
implements ModelResolver {
    private WeakReference<Contribution> contribution;
    private ProcessorContext context;
    private Map<String, ModelResolver> importResolvers = new HashMap<String, ModelResolver>();
    private Contribution contributionContainingClass;

    private static ClassLoader parentClassLoader(Contribution contribution) {
        if (contribution.getClassLoader() != null) {
            return contribution.getClassLoader();
        }
        ClassLoader parentClassLoader = ServiceDiscovery.getInstance().getContextClassLoader();
        return parentClassLoader;
    }

    private static URL[] getContributionURLs(Contribution contribution) throws IOException {
        if (contribution.getClassLoader() != null) {
            return new URL[0];
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new URL(contribution.getLocation()));
        urls.addAll(ContributionHelper.getNestedJarUrls(contribution));
        return urls.toArray(new URL[urls.size()]);
    }

    public ClassLoaderModelResolver(Contribution contribution, FactoryExtensionPoint modelFactories) throws IOException {
        super(ClassLoaderModelResolver.getContributionURLs(contribution), ClassLoaderModelResolver.parentClassLoader(contribution));
        this.contribution = new WeakReference<Contribution>(contribution);
        HashMap<String, ArrayList<ModelResolver>> resolverMap = new HashMap<String, ArrayList<ModelResolver>>();
        for (Import import_ : ((Contribution)this.contribution.get()).getImports()) {
            if (!(import_ instanceof JavaImport)) continue;
            JavaImport javaImport = (JavaImport)import_;
            ArrayList<ModelResolver> resolvers = (ArrayList<ModelResolver>)resolverMap.get(javaImport.getPackage());
            if (resolvers == null) {
                resolvers = new ArrayList<ModelResolver>();
                resolverMap.put(javaImport.getPackage(), resolvers);
            }
            resolvers.add(javaImport.getModelResolver());
        }
        for (Map.Entry entry : resolverMap.entrySet()) {
            this.importResolvers.put((String)entry.getKey(), new DefaultDelegatingModelResolver((List)entry.getValue()));
        }
    }

    @Override
    public void addModel(Object resolved, ProcessorContext context) {
        throw new IllegalStateException();
    }

    @Override
    public Object removeModel(Object resolved, ProcessorContext context) {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved, ProcessorContext context) {
        if (!(unresolved instanceof ClassReference)) {
            return unresolved;
        }
        try {
            this.context = context;
            this.contributionContainingClass = (Contribution)this.contribution.get();
            String className = ((ClassReference)unresolved).getClassName();
            Class<?> clazz = Class.forName(className, false, this);
            ClassReference classReference = new ClassReference(clazz);
            classReference.setContributionContainingClass(this.contributionContainingClass);
            this.contributionContainingClass = null;
            T t = modelClass.cast(classReference);
            return t;
        }
        catch (ClassNotFoundException e) {
            T t = unresolved;
            return t;
        }
        finally {
            this.contributionContainingClass = null;
        }
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        return url;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> resources = super.findResources(name);
        ArrayList<URL> allResources = new ArrayList<URL>();
        while (resources.hasMoreElements()) {
            allResources.add(resources.nextElement());
        }
        return Collections.enumeration(allResources);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ClassReference classReference;
        int d = name.lastIndexOf(46);
        String packageName = d != -1 ? name.substring(0, d) : null;
        ModelResolver importResolver = this.importResolvers.get(packageName);
        if (importResolver != null && !(classReference = importResolver.resolveModel(ClassReference.class, new ClassReference(name), this.context)).isUnresolved()) {
            this.contributionContainingClass = classReference.getContributionContainingClass();
            return classReference.getJavaClass();
        }
        Class<?> clazz = super.findClass(name);
        return clazz;
    }

    public void clear() {
        this.contribution = null;
        this.contributionContainingClass = null;
        this.context = null;
        this.importResolvers = null;
    }
}

