/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.DefaultArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtendedURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;

public class DefaultURLArtifactProcessorExtensionPoint
extends DefaultArtifactProcessorExtensionPoint<URLArtifactProcessor<?>>
implements URLArtifactProcessorExtensionPoint {
    private StAXArtifactProcessor<?> staxProcessor;
    private boolean loaded;

    public DefaultURLArtifactProcessorExtensionPoint(ExtensionPointRegistry extensionPoints) {
        super(extensionPoints);
        FactoryExtensionPoint modelFactories = this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        XMLInputFactory inputFactory = modelFactories.getFactory(XMLInputFactory.class);
        XMLOutputFactory outputFactory = modelFactories.getFactory(XMLOutputFactory.class);
        StAXArtifactProcessorExtensionPoint staxProcessors = extensionPoints.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.staxProcessor = new ExtensibleStAXArtifactProcessor(staxProcessors, inputFactory, outputFactory);
    }

    @Override
    public void addArtifactProcessor(URLArtifactProcessor<?> artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            Pattern pattern = Pattern.compile(DefaultURLArtifactProcessorExtensionPoint.wildcard2regex(artifactProcessor.getArtifactType()));
            this.processorsByArtifactType.put(pattern, artifactProcessor);
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.put(artifactProcessor.getModelType(), artifactProcessor);
        }
    }

    @Override
    public void removeArtifactProcessor(URLArtifactProcessor<?> artifactProcessor) {
        if (artifactProcessor.getArtifactType() != null) {
            String regex = DefaultURLArtifactProcessorExtensionPoint.wildcard2regex(artifactProcessor.getArtifactType());
            for (Object key : this.processorsByArtifactType.keySet()) {
                if (!(key instanceof Pattern) || !((Pattern)key).pattern().equals(regex)) continue;
                this.processorsByArtifactType.remove(key);
            }
            this.processorsByArtifactType.remove(artifactProcessor.getArtifactType());
        }
        if (artifactProcessor.getModelType() != null) {
            this.processorsByModelType.remove(artifactProcessor.getModelType());
        }
    }

    @Override
    public <T> URLArtifactProcessor<T> getProcessor(Class<T> modelType) {
        this.loadProcessors();
        return (URLArtifactProcessor)super.getProcessor(modelType);
    }

    @Override
    public Collection<URLArtifactProcessor<?>> getProcessors(Object artifactType) {
        this.loadProcessors();
        String uri = (String)artifactType;
        if (uri.endsWith("/")) {
            return Collections.emptyList();
        }
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        ArrayList processors = new ArrayList();
        for (Map.Entry e : this.processorsByArtifactType.entrySet()) {
            Pattern pattern = (Pattern)e.getKey();
            if (!pattern.matcher(uri).matches()) continue;
            processors.add((URLArtifactProcessor<?>)e.getValue());
        }
        return processors;
    }

    @Override
    public URLArtifactProcessor<?> getProcessor(Object artifactType) {
        Collection<URLArtifactProcessor<?>> processors = this.getProcessors(artifactType);
        return processors.isEmpty() ? null : processors.iterator().next();
    }

    private static String wildcard2regex(String pattern) {
        String wildcard = pattern;
        if (wildcard.endsWith("/")) {
            wildcard = wildcard + "**";
        }
        if (wildcard.startsWith(".")) {
            wildcard = "**/*" + wildcard;
        } else if (wildcard.indexOf(47) == -1) {
            wildcard = "**/" + wildcard;
        } else if (!wildcard.startsWith("/") && !wildcard.startsWith("**")) {
            wildcard = '/' + wildcard;
        }
        StringBuffer regex = new StringBuffer();
        char[] chars = wildcard.toCharArray();
        block5: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '*': {
                    if (i < chars.length - 1 && chars[i + 1] == '*') {
                        if (i < chars.length - 2) {
                            if (chars[i + 2] == '/') {
                                regex.append("(.*/)*");
                                i += 2;
                                continue block5;
                            }
                            throw new IllegalArgumentException("** can only be used as the name for a directory");
                        }
                        regex.append(".*");
                        ++i;
                        continue block5;
                    }
                    regex.append("[^/]*");
                    continue block5;
                }
                case '?': {
                    regex.append("[^/]");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '<': 
                case '>': 
                case '\\': 
                case '^': 
                case '|': {
                    regex.append("\\").append(chars[i]);
                    continue block5;
                }
                default: {
                    regex.append(chars[i]);
                }
            }
        }
        return regex.toString();
    }

    private synchronized void loadProcessors() {
        Collection<ServiceDeclaration> processorDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            processorDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations(URLArtifactProcessor.class.getName());
        }
        catch (IOException e) {
            IllegalStateException ie = new IllegalStateException(e);
            throw ie;
        }
        for (ServiceDeclaration processorDeclaration : processorDeclarations) {
            Map<String, String> attributes = processorDeclaration.getAttributes();
            String artifactType = attributes.get("type");
            String modelTypeName = attributes.get("model");
            LazyURLArtifactProcessor processor = new LazyURLArtifactProcessor(artifactType, modelTypeName, processorDeclaration, this.registry, this.staxProcessor);
            this.addArtifactProcessor(processor);
        }
        this.loaded = true;
    }

    private static class LazyURLArtifactProcessor
    implements ExtendedURLArtifactProcessor {
        private ExtensionPointRegistry extensionPoints;
        private String artifactType;
        private String modelTypeName;
        private ServiceDeclaration processorDeclaration;
        private URLArtifactProcessor<?> processor;
        private Class<?> modelType;
        private StAXArtifactProcessor<?> staxProcessor;

        LazyURLArtifactProcessor(String artifactType, String modelTypeName, ServiceDeclaration processorDeclaration, ExtensionPointRegistry extensionPoints, StAXArtifactProcessor<?> staxProcessor) {
            this.artifactType = artifactType;
            this.modelTypeName = modelTypeName;
            this.processorDeclaration = processorDeclaration;
            this.extensionPoints = extensionPoints;
            this.staxProcessor = staxProcessor;
        }

        @Override
        public String getArtifactType() {
            return this.artifactType;
        }

        private URLArtifactProcessor getProcessor() {
            if (this.processor == null) {
                try {
                    FactoryExtensionPoint modelFactories = this.extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
                    Class<?> processorClass = this.processorDeclaration.loadClass();
                    try {
                        Constructor<?> constructor = processorClass.getConstructor(FactoryExtensionPoint.class);
                        this.processor = (URLArtifactProcessor)constructor.newInstance(modelFactories);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Constructor<?> constructor = processorClass.getConstructor(FactoryExtensionPoint.class, StAXArtifactProcessor.class);
                            this.processor = (URLArtifactProcessor)constructor.newInstance(modelFactories, this.staxProcessor);
                        }
                        catch (NoSuchMethodException e2) {
                            Constructor<?> constructor = processorClass.getConstructor(ExtensionPointRegistry.class, StAXArtifactProcessor.class);
                            this.processor = (URLArtifactProcessor)constructor.newInstance(this.extensionPoints, this.staxProcessor);
                        }
                    }
                }
                catch (Throwable e) {
                    IllegalStateException ie = new IllegalStateException("Exception during getProcessor() for " + this.processorDeclaration.getClassName(), e);
                    throw ie;
                }
            }
            return this.processor;
        }

        @Override
        public Object read(URL contributionURL, URI artifactURI, URL artifactURL, ProcessorContext context) throws ContributionReadException {
            return this.getProcessor().read(contributionURL, artifactURI, artifactURL, context);
        }

        @Override
        public Class<?> getModelType() {
            if (this.modelTypeName != null && this.modelType == null) {
                try {
                    this.modelType = this.processorDeclaration.loadClass(this.modelTypeName);
                }
                catch (ClassNotFoundException e) {
                    IllegalStateException ie = new IllegalStateException(e);
                    throw ie;
                }
            }
            return this.modelType;
        }

        @Override
        public void resolve(Object model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
            this.getProcessor().resolve(model, resolver, context);
        }

        @Override
        public void preResolve(Object model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
            URLArtifactProcessor processor = this.getProcessor();
            if (processor instanceof ExtendedURLArtifactProcessor) {
                ((ExtendedURLArtifactProcessor)processor).preResolve(model, resolver, context);
            }
        }
    }
}

