/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.invocation.AsyncResponseException;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.InvokerAsyncRequest;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.oasisopen.sca.ServiceRuntimeException;

public class RuntimeInvoker
implements Invoker,
InvokerAsyncRequest {
    protected ExtensionPointRegistry registry;
    protected MessageFactory messageFactory;
    protected Invocable invocable;
    private ExecutorService theExecutor;

    public RuntimeInvoker(ExtensionPointRegistry registry, Invocable invocable) {
        this.registry = registry;
        this.messageFactory = registry.getExtensionPoint(FactoryExtensionPoint.class).getFactory(MessageFactory.class);
        this.invocable = invocable;
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        WorkScheduler scheduler = utilities.getUtility(WorkScheduler.class);
        this.theExecutor = scheduler.getExecutorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invokeBinding(Message msg) {
        Message context = ThreadMessageContext.setMessageContext(msg);
        try {
            Message message = this.invocable.getBindingInvocationChain().getHeadInvoker().invoke(msg);
            return message;
        }
        finally {
            ThreadMessageContext.setMessageContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeBindingAsync(Message msg) {
        Message context = ThreadMessageContext.setMessageContext(msg);
        try {
            ((InvokerAsyncRequest)((Object)this.invocable.getBindingInvocationChain().getHeadInvoker())).invokeAsyncRequest(msg);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            ThreadMessageContext.setMessageContext(context);
        }
    }

    @Override
    public Message invoke(Message msg) {
        return this.invoke(msg.getOperation(), msg);
    }

    public Object invoke(Operation operation, Object[] args) throws InvocationTargetException {
        Message msg = this.messageFactory.createMessage();
        msg.setBody(args);
        Message resp = this.invoke(operation, msg);
        Object body = resp.getBody();
        if (resp.isFault()) {
            throw new InvocationTargetException((Throwable)body);
        }
        return body;
    }

    public Message invoke(Operation operation, Message msg) {
        InvocationChain chain = this.invocable.getInvocationChain(operation);
        return this.invoke(chain, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message invoke(InvocationChain chain, Message msg) {
        if (this.invocable instanceof Endpoint) {
            msg.setTo((Endpoint)((Object)this.invocable));
        } else if (this.invocable instanceof EndpointReference) {
            msg.setFrom((EndpointReference)((Object)this.invocable));
        }
        Invoker headInvoker = chain.getHeadInvoker();
        Operation operation = chain.getTargetOperation();
        msg.setOperation(operation);
        Message msgContext = ThreadMessageContext.setMessageContext(msg);
        try {
            Message message = headInvoker.invoke(msg);
            return message;
        }
        finally {
            ThreadMessageContext.setMessageContext(msgContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAsync(Message msg) {
        Operation operation;
        InvocationChain chain;
        if (this.invocable instanceof Endpoint) {
            Endpoint ep = (Endpoint)((Object)this.invocable);
            msg.setTo(ep);
            if (!ep.isAsyncInvocation()) {
                throw new ServiceRuntimeException("Calling invokeAsync on a non-async endpoint - " + ep);
            }
        } else if (this.invocable instanceof EndpointReference) {
            RuntimeEndpointReference epr = (RuntimeEndpointReference)this.invocable;
            if (!epr.isAsyncInvocation()) {
                throw new ServiceRuntimeException("Calling invokeAsync on a non-async endpoint reference - " + epr);
            }
            if (epr.isOutOfDate()) {
                epr.rebuild();
            }
            msg.setFrom(epr);
            msg.setTo(epr.getTargetEndpoint());
        }
        if ((chain = this.invocable.getInvocationChain(operation = msg.getOperation())) == null) {
            throw new IllegalArgumentException("No matching operation is found: " + operation.getName());
        }
        if (!msg.getHeaders().containsKey("MESSAGE_ID")) {
            msg.getHeaders().put("MESSAGE_ID", UUID.randomUUID().toString());
            UUID.randomUUID().toString();
        }
        Invoker headInvoker = chain.getHeadInvoker();
        Message msgContext = ThreadMessageContext.setMessageContext(msg);
        try {
            try {
                ((InvokerAsyncRequest)((Object)headInvoker)).invokeAsyncRequest(msg);
            }
            catch (ServiceRuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                if (!(ex instanceof AsyncResponseException)) {
                    throw new ServiceRuntimeException(ex);
                }
            }
        }
        finally {
            ThreadMessageContext.setMessageContext(msgContext);
        }
    }

    public void invokeAsyncResponse(Message msg) {
        InvocationChain chain = this.invocable.getInvocationChain(msg.getOperation());
        Invoker tailInvoker = chain.getTailInvoker();
        ((InvokerAsyncResponse)((Object)tailInvoker)).invokeAsyncResponse(msg);
    }

    @Override
    public void invokeAsyncRequest(Message msg) throws Throwable {
        this.invokeAsync(msg);
    }
}

