/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding;

import org.apache.tuscany.sca.databinding.DataBinding;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.XMLTypeHelper;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public abstract class BaseDataBinding
implements DataBinding {
    private Class<?> baseType;
    private String name;

    protected BaseDataBinding(Class<?> baseType) {
        this(baseType.getName(), baseType);
    }

    protected BaseDataBinding(String name, Class<?> baseType) {
        this.name = name;
        this.baseType = baseType;
    }

    @Override
    public boolean introspect(DataType type, Operation operation) {
        assert (type != null);
        Class<?> cls = type.getPhysical();
        if (this.baseType != null && this.baseType.isAssignableFrom(cls)) {
            type.setDataBinding(this.getName());
            if (type.getLogical() == null) {
                type.setLogical(XMLType.UNKNOWN);
            }
            return true;
        }
        return false;
    }

    @Override
    public DataType introspect(Object value, Operation operation) {
        if (value == null) {
            return null;
        }
        DataTypeImpl dataType = new DataTypeImpl(value.getClass(), value.getClass());
        if (this.introspect(dataType, (Operation)null)) {
            return dataType;
        }
        return null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public WrapperHandler getWrapperHandler() {
        return null;
    }

    @Override
    public Object copy(Object object, DataType sourceDataType, DataType targetDataType, Operation sourceOperation, Operation targetOperation) {
        return object;
    }

    @Override
    public XMLTypeHelper getXMLTypeHelper() {
        return null;
    }
}

