/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.javabeans;

import javax.xml.namespace.QName;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.javabeans.Java2XMLMapperException;
import org.apache.tuscany.sca.databinding.javabeans.JavaBean2XMLTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JavaBean2DOMNodeTransformer
extends JavaBean2XMLTransformer<Node> {
    public static final String COLON = ":";
    private DOMHelper helper;

    public JavaBean2DOMNodeTransformer(ExtensionPointRegistry registry) {
        this.helper = DOMHelper.getInstance(registry);
    }

    @Override
    public void appendChild(Node parentElement, Node childElement) throws Java2XMLMapperException {
        parentElement.appendChild(childElement);
    }

    @Override
    public Node createElement(QName qName) throws Java2XMLMapperException {
        String qualifedName = qName.getPrefix() == null || qName.getPrefix().length() <= 0 ? qName.getLocalPart() : qName.getPrefix() + COLON + qName.getLocalPart();
        return this.helper.newDocument().createElementNS(qName.getNamespaceURI(), qualifedName);
    }

    @Override
    public void appendText(Node parentElement, String textData) throws Java2XMLMapperException {
        Node textNode;
        Document document = this.helper.newDocument();
        if (textData != null) {
            textNode = document.createTextNode(textData);
        } else {
            Attr nil = document.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:nil");
            nil.setValue("true");
            textNode = nil;
        }
        this.appendChild(parentElement, textNode);
    }

    @Override
    public Class getTargetType() {
        return Node.class;
    }
}

