/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.extensibility;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDeclarationParser;

public class ServiceHelper {
    private static final Class<?>[] ARG_TYPES = new Class[]{ExtensionPointRegistry.class, Map.class};

    private ServiceHelper() {
    }

    public static boolean start(Object instance) {
        if (instance instanceof LifeCycleListener) {
            ((LifeCycleListener)instance).start();
            return true;
        }
        return false;
    }

    public static boolean stop(Object instance) {
        if (instance instanceof LifeCycleListener) {
            ((LifeCycleListener)instance).stop();
            return true;
        }
        return false;
    }

    public static void stop(Collection<? extends Object> instances) {
        if (instances == null) {
            return;
        }
        for (Object object : instances) {
            if (!(object instanceof LifeCycleListener)) continue;
            ((LifeCycleListener)object).stop();
        }
    }

    public static <T> T newInstance(Class<T> cls, Class<?> parameterType, Object parameter) throws Exception {
        Constructor<T> constructor = cls.getConstructor(parameterType);
        return constructor.newInstance(parameter);
    }

    public static <T> T newInstance(Class<T> cls, Class<?>[] parameterTypes, Object ... parameters) throws Exception {
        Constructor<T> constructor = cls.getConstructor(parameterTypes);
        return constructor.newInstance(parameters);
    }

    public static <T> T newInstance(Class<T> cls) throws Exception {
        Constructor<T> constructor = cls.getConstructor(new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    public static <T> T newInstance(ExtensionPointRegistry registry, ServiceDeclaration sd) throws Exception {
        Class<?> cls = sd.loadClass();
        T instance = null;
        try {
            instance = (T)ServiceHelper.newInstance(cls, ExtensionPointRegistry.class, (Object)registry);
        }
        catch (NoSuchMethodException e) {
            try {
                instance = (T)ServiceHelper.newInstance(cls, ARG_TYPES, registry, sd.getAttributes());
            }
            catch (NoSuchMethodException e1) {
                instance = (T)ServiceHelper.newInstance(cls);
            }
        }
        return instance;
    }

    public static <T> T newLazyInstance(ExtensionPointRegistry registry, ServiceDeclaration sd, Class<T> serviceType) {
        return serviceType.cast(Proxy.newProxyInstance(serviceType.getClassLoader(), new Class[]{serviceType, LifeCycleListener.class}, (InvocationHandler)new InvocationHandlerImpl(registry, serviceType, sd)));
    }

    private static class InvocationHandlerImpl
    implements InvocationHandler {
        private ExtensionPointRegistry registry;
        private Class<?> type;
        private ServiceDeclaration sd;
        private Object instance;
        private static final Method STOP_METHOD = InvocationHandlerImpl.getMethod(LifeCycleListener.class, "stop");
        private static final Method START_METHOD = InvocationHandlerImpl.getMethod(LifeCycleListener.class, "start");
        private static final Method EQUALS_METHOD = InvocationHandlerImpl.getMethod(Object.class, "equals");
        private static final Method HASHCODE_METHOD = InvocationHandlerImpl.getMethod(Object.class, "hashCode");
        private static final Method TOSTRING_METHOD = InvocationHandlerImpl.getMethod(Object.class, "toString");

        private static Method getMethod(Class<?> type, String name) {
            Method[] methods;
            for (Method method : methods = type.getMethods()) {
                if (!name.equals(method.getName())) continue;
                return method;
            }
            return null;
        }

        public InvocationHandlerImpl(ExtensionPointRegistry registry, Class<?> type, ServiceDeclaration sd) {
            this.registry = registry;
            this.sd = sd;
            this.type = type;
        }

        private Object getAttribute(Method method) throws Exception {
            if (method.getParameterTypes().length != 0) {
                return null;
            }
            String name = method.getName();
            if (name.equals("getModelType") && method.getReturnType() == Class.class) {
                return this.sd.loadClass(this.sd.getAttributes().get("model"));
            }
            if (name.equals("getArtifactType")) {
                return ServiceDeclarationParser.getQName(this.sd.getAttributes().get("qname"));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            InvocationHandlerImpl invocationHandlerImpl = this;
            synchronized (invocationHandlerImpl) {
                Object value = this.getAttribute(method);
                if (value != null) {
                    return value;
                }
                if (this.instance == null && method.getDeclaringClass() == this.type) {
                    this.instance = ServiceHelper.newInstance(this.registry, this.sd);
                    ServiceHelper.start(this.instance);
                }
                if (method.equals(EQUALS_METHOD)) {
                    return proxy == args[0];
                }
                if (method.equals(HASHCODE_METHOD)) {
                    return System.identityHashCode(proxy);
                }
                if (method.equals(TOSTRING_METHOD)) {
                    return "Proxy: " + this.sd.toString();
                }
                if (this.instance == null) {
                    return null;
                }
            }
            if (method.equals(STOP_METHOD)) {
                ServiceHelper.stop(this.instance);
                return null;
            }
            if (method.equals(START_METHOD)) {
                return null;
            }
            return method.invoke(this.instance, args);
        }
    }
}

