/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.corba;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceHelper;
import org.apache.tuscany.sca.host.corba.CorbaHost;
import org.apache.tuscany.sca.host.corba.CorbaHostExtensionPoint;
import org.oasisopen.sca.ServiceRuntimeException;

public class DefaultCorbaHostExtensionPoint
implements CorbaHostExtensionPoint,
LifeCycleListener {
    private ExtensionPointRegistry registry;
    private boolean loaded;
    private List<CorbaHost> corbaHosts = new ArrayList<CorbaHost>();

    public DefaultCorbaHostExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    private synchronized void loadHosts() {
        if (this.loaded) {
            return;
        }
        try {
            ServiceDeclaration sd = this.registry.getServiceDiscovery().getServiceDeclaration(CorbaHost.class);
            CorbaHost host = (CorbaHost)ServiceHelper.newInstance(this.registry, sd);
            ServiceHelper.start(host);
            this.corbaHosts.add(host);
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public void addCorbaHost(CorbaHost host) {
        this.corbaHosts.add(host);
    }

    @Override
    public void removeCorbaHost(CorbaHost host) {
        this.corbaHosts.remove(host);
    }

    @Override
    public List<CorbaHost> getCorbaHosts() {
        this.loadHosts();
        return this.corbaHosts;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        ServiceHelper.stop(this.corbaHosts);
        this.corbaHosts.clear();
        this.loaded = false;
    }
}

