/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.host.webapp;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class WebAppRequestDispatcher
implements RequestDispatcher {
    private String servletPath;
    private Servlet servlet;

    public WebAppRequestDispatcher(String mapping, Servlet servlet) {
        if (mapping.endsWith("*")) {
            mapping = mapping.substring(0, mapping.length() - 1);
        }
        if (mapping.endsWith("/")) {
            mapping = mapping.substring(0, mapping.length() - 1);
        }
        this.servletPath = mapping;
        this.servlet = servlet;
    }

    private HttpServletRequest createRequestWrapper(ServletRequest request) {
        HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper((HttpServletRequest)request){

            public String getServletPath() {
                return WebAppRequestDispatcher.this.servletPath;
            }

            public String getPathInfo() {
                String path = super.getServletPath();
                if (path.length() == 0) {
                    path = super.getPathInfo();
                }
                path = WebAppRequestDispatcher.this.fiddlePath(path, WebAppRequestDispatcher.this.servletPath);
                return path;
            }
        };
        return requestWrapper;
    }

    protected String fiddlePath(String path, String servletPath) {
        if (path.startsWith(servletPath)) {
            return path.substring(servletPath.length());
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        if (st.countTokens() == 1) {
            return path;
        }
        String root = "";
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (!servletPath.endsWith(root + "/" + s)) break;
            root = root + "/" + s;
        }
        String fiddlePath = path.substring(root.length());
        return fiddlePath;
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.servlet.service((ServletRequest)this.createRequestWrapper(request), response);
    }

    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.servlet.service((ServletRequest)this.createRequestWrapper(request), response);
    }
}

