/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.http.jetty;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.host.http.DefaultResourceServlet;
import org.apache.tuscany.sca.host.http.HttpScheme;
import org.apache.tuscany.sca.host.http.SecurityContext;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletMappingException;
import org.apache.tuscany.sca.host.http.extensibility.HttpPortAllocator;
import org.apache.tuscany.sca.http.jetty.JettyDefaultServlet;
import org.apache.tuscany.sca.http.jetty.JettyLogger;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletMapping;
import org.mortbay.jetty.servlet.SessionHandler;
import org.mortbay.log.Log;
import org.mortbay.log.Logger;
import org.mortbay.thread.ThreadPool;

public class JettyServer
implements ServletHost,
LifeCycleListener {
    private static final java.util.logging.Logger logger = java.util.logging.Logger.getLogger(JettyServer.class.getName());
    private final Object joinLock = new Object();
    private String trustStore;
    private String trustStorePassword;
    private String keyStore;
    private String keyStorePassword;
    private String keyStoreType;
    private String trustStoreType;
    private boolean sendServerVersion;
    private WorkScheduler workScheduler;
    private HttpPortAllocator httpPortAllocator;
    public static int portDefault = 0;
    private int defaultPort;
    private int defaultSSLPort;
    private Map<Integer, Port> ports = new HashMap<Integer, Port>();
    private String contextPath = "/";
    private Logger jettyLogger;

    public JettyServer(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilityExtensionPoint = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.workScheduler = utilityExtensionPoint.getUtility(WorkScheduler.class);
        this.httpPortAllocator = utilityExtensionPoint.getUtility(HttpPortAllocator.class);
        this.init();
    }

    protected JettyServer(WorkScheduler workScheduler, HttpPortAllocator httpPortAllocator) {
        this.httpPortAllocator = httpPortAllocator;
        this.workScheduler = workScheduler;
        this.init();
    }

    private void init() {
        this.defaultPort = this.httpPortAllocator.getDefaultPort(HttpScheme.HTTP);
        if (portDefault > 0) {
            this.defaultPort = portDefault;
        }
        this.defaultSSLPort = this.httpPortAllocator.getDefaultPort(HttpScheme.HTTPS);
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                JettyServer.this.trustStore = System.getProperty("javax.net.ssl.trustStore");
                JettyServer.this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
                JettyServer.this.keyStore = System.getProperty("javax.net.ssl.keyStore");
                JettyServer.this.keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
                JettyServer.this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
                JettyServer.this.trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                System.setProperty("JETTY_NO_SHUTDOWN_HOOK", "true");
                return null;
            }
        });
    }

    @Override
    public String getName() {
        return "jetty";
    }

    @Override
    public void setDefaultPort(int port) {
        this.defaultPort = port;
    }

    @Override
    public int getDefaultPort() {
        return this.defaultPort;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this.sendServerVersion = sendServerVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.joinLock;
        synchronized (object) {
            this.joinLock.notifyAll();
        }
        try {
            HashSet<Map.Entry<Integer, Port>> entries = new HashSet<Map.Entry<Integer, Port>>(this.ports.entrySet());
            for (Map.Entry entry : entries) {
                Port port = (Port)entry.getValue();
                Server server = port.getServer();
                server.stop();
                server.setStopAtShutdown(false);
                this.ports.remove(entry.getKey());
            }
        }
        catch (Exception e) {
            throw new ServletMappingException(e);
        }
        finally {
            if (this.jettyLogger != null) {
                Log.setLog((Logger)this.jettyLogger);
                this.jettyLogger = null;
            }
        }
    }

    private void configureSSL(SslSocketConnector connector, SecurityContext securityContext) {
        connector.setProtocol("TLS");
        if (securityContext != null) {
            this.keyStoreType = securityContext.getSSLProperties().getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
            this.keyStore = securityContext.getSSLProperties().getProperty("javax.net.ssl.keyStore");
            this.keyStorePassword = securityContext.getSSLProperties().getProperty("javax.net.ssl.keyStorePassword");
            this.trustStoreType = securityContext.getSSLProperties().getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
            this.trustStore = securityContext.getSSLProperties().getProperty("javax.net.ssl.trustStore");
            this.trustStorePassword = securityContext.getSSLProperties().getProperty("javax.net.ssl.trustStorePassword");
        }
        connector.setKeystore(this.keyStore);
        connector.setKeyPassword(this.keyStorePassword);
        connector.setKeystoreType(this.keyStoreType);
        connector.setTruststore(this.trustStore);
        connector.setTrustPassword(this.trustStorePassword);
        connector.setTruststoreType(this.trustStoreType);
        connector.setPassword(this.keyStorePassword);
        if (this.trustStore != null) {
            connector.setNeedClientAuth(true);
        }
    }

    @Override
    public String addServletMapping(String suri, Servlet servlet) throws ServletMappingException {
        return this.addServletMapping(suri, servlet, null);
    }

    @Override
    public String addServletMapping(String suri, Servlet servlet, SecurityContext securityContext) throws ServletMappingException {
        URL addedURL;
        ServletHolder holder;
        Port port;
        int portNumber;
        URI uri = URI.create(suri);
        String scheme = null;
        if (securityContext != null && securityContext.isSSLEnabled()) {
            scheme = "https";
        } else {
            scheme = uri.getScheme();
            if (scheme == null) {
                scheme = "http";
            }
        }
        String host = uri.getHost();
        if ("0.0.0.0".equals(host)) {
            host = null;
        }
        if ((portNumber = uri.getPort()) == -1) {
            portNumber = "http".equals(scheme) ? this.defaultPort : this.defaultSSLPort;
        }
        if ((port = this.ports.get(portNumber)) == null) {
            try {
                Server server = new Server();
                server.setThreadPool((ThreadPool)new WorkSchedulerThreadPool());
                if ("https".equals(scheme)) {
                    SslSocketConnector sslConnector = new SslSocketConnector();
                    sslConnector.setPort(portNumber);
                    sslConnector.setHost(host);
                    this.configureSSL(sslConnector, securityContext);
                    server.setConnectors(new Connector[]{sslConnector});
                } else {
                    SelectChannelConnector selectConnector = new SelectChannelConnector();
                    selectConnector.setPort(portNumber);
                    selectConnector.setHost(host);
                    server.setConnectors(new Connector[]{selectConnector});
                }
                ContextHandler contextHandler = new ContextHandler();
                contextHandler.setContextPath("/");
                server.setHandler((Handler)contextHandler);
                SessionHandler sessionHandler = new SessionHandler();
                ServletHandler servletHandler = new ServletHandler();
                sessionHandler.addHandler((Handler)servletHandler);
                contextHandler.setHandler((Handler)sessionHandler);
                server.setStopAtShutdown(true);
                server.setSendServerVersion(this.sendServerVersion);
                server.start();
                port = new Port(server, servletHandler);
                this.ports.put(portNumber, port);
            }
            catch (Exception e) {
                throw new ServletMappingException(e);
            }
        }
        ServletHandler servletHandler = port.getServletHandler();
        if (servlet instanceof DefaultResourceServlet) {
            String servletPath = uri.getPath();
            if (servletPath.endsWith("*")) {
                servletPath = servletPath.substring(0, servletPath.length() - 1);
            }
            if (servletPath.endsWith("/")) {
                servletPath = servletPath.substring(0, servletPath.length() - 1);
            }
            if (!servletPath.startsWith("/")) {
                servletPath = '/' + servletPath;
            }
            DefaultResourceServlet resourceServlet = (DefaultResourceServlet)servlet;
            JettyDefaultServlet defaultServlet = new JettyDefaultServlet(servletPath, resourceServlet.getDocumentRoot());
            holder = new ServletHolder((Servlet)defaultServlet);
        } else {
            holder = new ServletHolder(servlet);
        }
        servletHandler.addServlet(holder);
        ServletMapping mapping = new ServletMapping();
        mapping.setServletName(holder.getName());
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        mapping.setPathSpec(path);
        servletHandler.addServletMapping(mapping);
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                host = "localhost";
            }
        }
        try {
            addedURL = new URL(scheme, host, portNumber, path);
        }
        catch (MalformedURLException e) {
            throw new ServletMappingException(e);
        }
        logger.info("Added Servlet mapping: " + addedURL);
        return addedURL.toString();
    }

    @Override
    public URL getURLMapping(String suri, SecurityContext securityContext) throws ServletMappingException {
        return this.map(suri, securityContext, true);
    }

    private URL map(String suri, SecurityContext securityContext, boolean resolve) throws ServletMappingException {
        URL url;
        String path;
        String host;
        URI uri = URI.create(suri);
        String scheme = null;
        if (securityContext != null && securityContext.isSSLEnabled()) {
            scheme = "https";
        } else {
            scheme = uri.getScheme();
            if (scheme == null) {
                scheme = "http";
            }
        }
        int portNumber = uri.getPort();
        if (portNumber == -1) {
            portNumber = "http".equals(scheme) ? this.defaultPort : this.defaultSSLPort;
        }
        if ((host = uri.getHost()) == null) {
            host = "0.0.0.0";
            if (resolve) {
                try {
                    host = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    host = "localhost";
                }
            }
        }
        if (!(path = uri.getPath()).startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        try {
            url = new URL(scheme, host, portNumber, path);
        }
        catch (MalformedURLException e) {
            throw new ServletMappingException(e);
        }
        return url;
    }

    @Override
    public Servlet getServletMapping(String suri) throws ServletMappingException {
        Port port;
        if (suri == null) {
            return null;
        }
        URI uri = URI.create(suri);
        int portNumber = uri.getPort();
        if (portNumber == -1) {
            portNumber = this.defaultPort;
        }
        if ((port = this.ports.get(portNumber)) == null) {
            return null;
        }
        ServletHandler servletHandler = port.getServletHandler();
        Servlet servlet = null;
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>(Arrays.asList(servletHandler.getServletMappings()));
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        for (ServletMapping mapping : mappings) {
            if (!Arrays.asList(mapping.getPathSpecs()).contains(path)) continue;
            try {
                servlet = servletHandler.getServlet(mapping.getServletName()).getServlet();
                break;
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
        }
        return servlet;
    }

    @Override
    public Servlet removeServletMapping(String suri) {
        Port port;
        URI uri = URI.create(suri);
        int portNumber = uri.getPort();
        if (portNumber == -1) {
            portNumber = this.defaultPort;
        }
        if ((port = this.ports.get(portNumber)) == null) {
            logger.warning("No servlet registered at this URI: " + suri);
            return null;
        }
        ServletHandler servletHandler = port.getServletHandler();
        Servlet removedServlet = null;
        ArrayList<ServletMapping> mappings = new ArrayList<ServletMapping>(Arrays.asList(servletHandler.getServletMappings()));
        String path = uri.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (!path.startsWith(this.contextPath)) {
            path = this.contextPath + path;
        }
        for (ServletMapping mapping : mappings) {
            if (!Arrays.asList(mapping.getPathSpecs()).contains(path)) continue;
            try {
                removedServlet = servletHandler.getServlet(mapping.getServletName()).getServlet();
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
            mappings.remove(mapping);
            logger.info("Removed Servlet mapping: " + path);
            break;
        }
        if (removedServlet != null) {
            servletHandler.setServletMappings(mappings.toArray(new ServletMapping[mappings.size()]));
            if (mappings.size() == 0) {
                try {
                    Server server = port.getServer();
                    server.stop();
                    server.setStopAtShutdown(false);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                this.ports.remove(portNumber);
            }
        } else {
            logger.warning("Trying to Remove servlet mapping: " + path + " where mapping is not registered");
        }
        return removedServlet;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String suri) throws ServletMappingException {
        return null;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setContextPath(String path) {
        this.contextPath = path;
    }

    @Override
    public void setAttribute(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void start() {
        try {
            this.jettyLogger = new JettyLogger(logger);
            Log.setLog((Logger)this.jettyLogger);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public ServletContext getServletContext() {
        if (this.ports.size() > 0) {
            return this.ports.values().iterator().next().getServletHandler().getServletContext();
        }
        return null;
    }

    private class WorkSchedulerThreadPool
    implements ThreadPool {
        private WorkSchedulerThreadPool() {
        }

        public boolean dispatch(Runnable work) {
            JettyServer.this.workScheduler.scheduleWork(work);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void join() throws InterruptedException {
            Object object = JettyServer.this.joinLock;
            synchronized (object) {
                JettyServer.this.joinLock.wait();
            }
        }

        public int getThreads() {
            throw new UnsupportedOperationException();
        }

        public int getIdleThreads() {
            throw new UnsupportedOperationException();
        }

        public boolean isLowOnThreads() {
            return false;
        }
    }

    private class Port {
        private Server server;
        private ServletHandler servletHandler;

        private Port(Server server, ServletHandler servletHandler) {
            this.server = server;
            this.servletHandler = servletHandler;
        }

        public Server getServer() {
            return this.server;
        }

        public ServletHandler getServletHandler() {
            return this.servletHandler;
        }
    }
}

