/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaConstructorImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.JavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;

public class JavaClassIntrospectorImpl {
    private List<JavaClassVisitor> visitors;

    public JavaClassIntrospectorImpl(List<JavaClassVisitor> visitors) {
        this.visitors = visitors;
    }

    public void introspectClass(JavaImplementation type, Class<?> clazz) throws IntrospectionException {
        for (JavaClassVisitor visitor : this.visitors) {
            visitor.visitClass(clazz, type);
            for (Constructor<?> constructor : clazz.getConstructors()) {
                visitor.visitConstructor(constructor, type);
                JavaConstructorImpl definition = type.getConstructors().get(constructor);
                if (definition == null) continue;
                for (JavaParameterImpl p : definition.getParameters()) {
                    visitor.visitConstructorParameter(p, type);
                }
            }
            Set<Field> fields = JavaIntrospectionHelper.getInjectableFields(clazz, true);
            for (Field field : fields) {
                visitor.visitField(field, type);
            }
            Set<Method> methods = JavaIntrospectionHelper.getAllUniquePublicProtectedMethods(clazz, true);
            for (Method method : methods) {
                visitor.visitMethod(method, type);
            }
            Set<Method> privateMethods = JavaIntrospectionHelper.getPrivateMethods(clazz);
            for (Method method : privateMethods) {
                visitor.visitMethod(method, type);
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null) {
                this.visitSuperClass(superClass, type, visitor);
            }
            visitor.visitEnd(clazz, type);
        }
    }

    private void visitSuperClass(Class<?> clazz, JavaImplementation type, JavaClassVisitor visitor) throws IntrospectionException {
        if (!Object.class.equals(clazz)) {
            visitor.visitSuperClass(clazz, type);
            clazz = clazz.getSuperclass();
            if (clazz != null) {
                this.visitSuperClass(clazz, type, visitor);
            }
        }
    }
}

